/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.CheckingMatcher;
import io.timeandspace.jpsg.CheckingPattern;
import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.PrimitiveType;
import io.timeandspace.jpsg.SimpleOption;
import io.timeandspace.jpsg.TemplateProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J,\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lio/timeandspace/jpsg/ConstProcessor;", "Lio/timeandspace/jpsg/TemplateProcessor;", "()V", "priority", "", "process", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "source", "Lio/timeandspace/jpsg/Context;", "target", "template", "", "Companion", "core"})
public final class ConstProcessor
extends TemplateProcessor {
    public static final int PRIORITY = -10;
    private static final String PREFIX = "/[*/]\\s*const\\s+(?<dim>\\w+)";
    private static final CheckingPattern CONST_PATTERN;
    public static final Companion Companion;

    @Override
    protected void process(@NotNull StringBuilder builder, @NotNull Context source, @NotNull Context target, @NotNull String template) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        String template2 = template;
        CheckingMatcher valueM = CONST_PATTERN.matcher(template2);
        StringBuilder sb = new StringBuilder();
        while (valueM.find()) {
            String dim = valueM.group("dim");
            Option option = target.getOption(dim);
            if (option != null) {
                String string;
                if (option instanceof SimpleOption) {
                    throw (Throwable)MalformedTemplateException.Companion.near(template2, valueM.start(), "Constant values are not supported for simple options, " + dim + " option: " + option);
                }
                String value = valueM.group("value");
                String replacementValue = null;
                String string2 = value;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (StringsKt.equals((String)"default", (String)string2, (boolean)true)) {
                    String string3 = option.defaultValue();
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"option.defaultValue()");
                } else {
                    if (!(option instanceof PrimitiveType) || !((PrimitiveType)option).isNumeric) {
                        throw (Throwable)MalformedTemplateException.Companion.near(template2, valueM.start(), "Constant values other than 'default' are supported only for primitive numeric types, " + "value: " + value + ", " + dim + " option: " + option);
                    }
                    String string4 = StringsKt.equals((String)"min", (String)value, (boolean)true) ? ((PrimitiveType)option).minValue() : (StringsKt.equals((String)"max", (String)value, (boolean)true) ? ((PrimitiveType)option).maxValue() : ((PrimitiveType)option).formatValue(value));
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"when {\n                 \u2026ue)\n                    }");
                }
                replacementValue = string;
                valueM.appendSimpleReplacement(sb, replacementValue);
                continue;
            }
            throw (Throwable)MalformedTemplateException.Companion.near(template2, valueM.start(), "Nonexistent dimension: " + dim + ", available dims: " + target);
        }
        valueM.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        template2 = string;
        this.postProcess(builder, source, target, template2);
    }

    @Override
    protected int priority() {
        return -10;
    }

    static {
        Companion = new Companion(null);
        CONST_PATTERN = CheckingPattern.compile(PREFIX, "/[*/]\\s*const\\s+(?<dim>\\w+)\\s+(?<value>-?\\d+|min|max|default)\\s*[*/]/([^/]*?/[*/]\\s*endconst\\s*[*/]/|\\s*+[\\w$]++(\\.[\\w$]++)?)");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/timeandspace/jpsg/ConstProcessor$Companion;", "", "()V", "CONST_PATTERN", "Lio/timeandspace/jpsg/CheckingPattern;", "kotlin.jvm.PlatformType", "PREFIX", "", "PRIORITY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

