/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.Dimensions;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.NonexistentDimensionException;
import java.util.ArrayList;
import java.util.List;

public final class Condition {
    private static final String POSSIBLY_NEGATED_DIMENSIONS = String.format("(%s|!?\\(%s\\))", "(?<dimensions>(\\s*(?<options>([\\w]+)((\\|[\\w]+)+)?)\\s+(?<dim>\\w+)\\s*)+)", "(?<dimensions>(\\s*(?<options>([\\w]+)((\\|[\\w]+)+)?)\\s+(?<dim>\\w+)\\s*)+)");
    static final String CONDITION = String.format("((%s\\s*\\|\\|\\s*)*|(%s\\s*&&\\s*)*)\\s*%s", POSSIBLY_NEGATED_DIMENSIONS, POSSIBLY_NEGATED_DIMENSIONS, POSSIBLY_NEGATED_DIMENSIONS).replaceAll("\\?<\\w+?>", "");
    private Op op;
    private final List<Dimensions> allDims = new ArrayList<Dimensions>();
    private final List<Boolean> negated = new ArrayList<Boolean>();

    static Condition parseCheckedCondition(String condition, Dimensions.Parser dimensionsParser, Context context, CharSequence input, int pos) {
        try {
            return Condition.parse(condition, dimensionsParser, context);
        }
        catch (NonexistentDimensionException e) {
            throw MalformedTemplateException.near(input, pos, "Nonexistent dimension in condition, context: " + context);
        }
    }

    static Condition parse(String condition, Dimensions.Parser dimensionsParser, Context context) throws NonexistentDimensionException {
        Condition cond = new Condition();
        String[] allDims = condition.split("\\|\\|");
        if (allDims.length > 1) {
            cond.op = Op.OR;
        } else {
            allDims = condition.split("&&");
            cond.op = Op.AND;
        }
        for (String dims : allDims) {
            if ((dims = dims.trim()).startsWith("!")) {
                cond.negated.add(true);
                dims = dims.substring(1);
            } else {
                cond.negated.add(false);
            }
            if (dims.startsWith("(")) {
                dims = dims.substring(1, dims.length() - 1);
            }
            cond.allDims.add(dimensionsParser.parseForCondition(dims, context));
        }
        return cond;
    }

    private boolean dimsResult(int i, Context target) {
        boolean res = this.allDims.get(i).checkAsCondition(target);
        if (this.negated.get(i).booleanValue()) {
            res = !res;
        }
        return res;
    }

    boolean check(Context target) {
        boolean res = this.dimsResult(0, target);
        for (int i = 1; i < this.allDims.size(); ++i) {
            boolean dimsRes = this.dimsResult(i, target);
            res = this.op == Op.OR ? res || dimsRes : res && dimsRes;
        }
        return res;
    }

    private static enum Op {
        AND,
        OR;

    }
}

