/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.PrimitiveTypeModifierPostProcessor;
import io.timeandspace.jpsg.RegexpUtils;
import io.timeandspace.jpsg.TemplateProcessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AAnProcessor
extends TemplateProcessor {
    public static final int PRIORITY = PrimitiveTypeModifierPostProcessor.getPRIORITY() - 10;
    private static final Pattern ARTICLE_PATTERN = RegexpUtils.compile("/[*/]an?[*/]/");
    private static final Pattern LETTER_PATTERN = RegexpUtils.compile("[a-zA-Z]");

    @Override
    protected int priority() {
        return PRIORITY;
    }

    @Override
    protected void process(StringBuilder builder, Context source, Context target, String template) {
        Matcher articleM = ARTICLE_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (articleM.find()) {
            char letter;
            String textAfterArticle = template.substring(articleM.end());
            Matcher letterAfterArticle = LETTER_PATTERN.matcher(textAfterArticle);
            block1: while (true) {
                if (!letterAfterArticle.find()) {
                    throw MalformedTemplateException.near(template, articleM.end());
                }
                letter = textAfterArticle.charAt(letterAfterArticle.start());
                if (!AAnProcessor.containsAtIndex(textAfterArticle, letterAfterArticle.start(), "code") && !AAnProcessor.containsAtIndex(textAfterArticle, letterAfterArticle.start(), "link")) break;
                int i = 0;
                while (true) {
                    if (i >= 3) continue block1;
                    letterAfterArticle.find();
                    ++i;
                }
                break;
            }
            String article = AAnProcessor.isVowel(letter) ? "an" : "a";
            articleM.appendReplacement(sb, article);
        }
        articleM.appendTail(sb);
        this.postProcess(builder, source, target, sb.toString());
    }

    private static boolean containsAtIndex(String s, int startIndex, String part) {
        return s.indexOf(part, startIndex) == startIndex;
    }

    private static boolean isVowel(char c) {
        return "aeiouAEIOU".indexOf(c) >= 0;
    }
}

