/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;

public class GetCQStats
extends BaseCQCommand {
    private static final GetCQStats singleton = new GetCQStats();

    public static Command getCommand() {
        return singleton;
    }

    private GetCQStats() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received close all client CQs request from {}", (Object)servConn.getName(), (Object)servConn.getSocketString());
        }
        String cqName = msg.getPart(0).getString();
        if (isDebugEnabled) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = "The cqName for the cq stats request is null";
            this.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        this.securityService.authorizeClusterRead();
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
        }
        catch (Exception e) {
            String err = "Exception while Getting the CQ Statistics. ";
            this.sendCqResponse(50, err, msg.getTransactionId(), e, servConn);
            return;
        }
        this.sendCqResponse(6, "cq stats sent successfully.", msg.getTransactionId(), null, servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessGetCqStatsTime(start - oldStart);
    }
}

