/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceImpl;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;
import org.apache.logging.log4j.Logger;

public class CqServiceVsdStats {
    private static final Logger logger = LogService.getLogger();
    private static final StatisticsType _type;
    protected static final String CQS_CREATED = "numCqsCreated";
    protected static final String CQS_ACTIVE = "numCqsActive";
    protected static final String CQS_STOPPED = "numCqsStopped";
    protected static final String CQS_CLOSED = "numCqsClosed";
    protected static final String CQS_ON_CLIENT = "numCqsOnClient";
    protected static final String CLIENTS_WITH_CQS = "numClientsWithCqs";
    protected static final String CQ_QUERY_EXECUTION_TIME = "cqQueryExecutionTime";
    protected static final String CQ_QUERY_EXECUTION_IN_PROGRESS = "cqQueryExecutionInProgress";
    protected static final String CQ_QUERY_EXECUTIONS_COMPLETED = "cqQueryExecutionsCompleted";
    protected static final String UNIQUE_CQ_QUERY = "numUniqueCqQuery";
    private static final int _numCqsCreatedId;
    private static final int _numCqsActiveId;
    private static final int _numCqsStoppedId;
    private static final int _numCqsClosedId;
    private static final int _numCqsOnClientId;
    private static final int _numClientsWithCqsId;
    private static final int _cqQueryExecutionTimeId;
    private static final int _cqQueryExecutionInProgressId;
    private static final int _cqQueryExecutionsCompletedId;
    private static final int _numUniqueCqQuery;
    private final Statistics _stats;

    public CqServiceVsdStats(StatisticsFactory factory) {
        this._stats = factory.createAtomicStatistics(_type, "CqServiceStats");
    }

    public void close() {
        this._stats.close();
    }

    public long getNumCqsCreated() {
        return this._stats.getLong(_numCqsCreatedId);
    }

    public void incCqsCreated() {
        this._stats.incLong(_numCqsCreatedId, 1L);
    }

    public long getNumCqsActive() {
        return this._stats.getLong(_numCqsActiveId);
    }

    public void incCqsActive() {
        this._stats.incLong(_numCqsActiveId, 1L);
    }

    public void decCqsActive() {
        this._stats.incLong(_numCqsActiveId, -1L);
    }

    public long getNumCqsStopped() {
        return this._stats.getLong(_numCqsStoppedId);
    }

    public void incCqsStopped() {
        this._stats.incLong(_numCqsStoppedId, 1L);
    }

    public void decCqsStopped() {
        this._stats.incLong(_numCqsStoppedId, -1L);
    }

    public long getNumCqsClosed() {
        return this._stats.getLong(_numCqsClosedId);
    }

    public void incCqsClosed() {
        this._stats.incLong(_numCqsClosedId, 1L);
    }

    public long getNumCqsOnClient() {
        return this._stats.getLong(_numCqsOnClientId);
    }

    public void incCqsOnClient() {
        this._stats.incLong(_numCqsOnClientId, 1L);
    }

    public void decCqsOnClient() {
        this._stats.incLong(_numCqsOnClientId, -1L);
    }

    public long getNumClientsWithCqs() {
        return this._stats.getLong(_numClientsWithCqsId);
    }

    public void incClientsWithCqs() {
        this._stats.incLong(_numClientsWithCqsId, 1L);
    }

    public void decClientsWithCqs() {
        this._stats.incLong(_numClientsWithCqsId, -1L);
    }

    public long startCqQueryExecution() {
        this._stats.incInt(_cqQueryExecutionInProgressId, 1);
        return NanoTimer.getTime();
    }

    public void endCqQueryExecution(long start) {
        long ts = NanoTimer.getTime();
        this._stats.incLong(_cqQueryExecutionTimeId, ts - start);
        this._stats.incInt(_cqQueryExecutionInProgressId, -1);
        this._stats.incLong(_cqQueryExecutionsCompletedId, 1L);
    }

    public long getCqQueryExecutionTime() {
        return this._stats.getLong(_cqQueryExecutionTimeId);
    }

    public void incUniqueCqQuery() {
        this._stats.incInt(_numUniqueCqQuery, 1);
    }

    public void decUniqueCqQuery() {
        this._stats.incInt(_numUniqueCqQuery, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long numCqsOnRegion(String regionName) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return 0L;
        }
        DefaultQueryService queryService = (DefaultQueryService)cache.getQueryService();
        CqService cqService = null;
        try {
            cqService = queryService.getCqService();
        }
        catch (CqException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get CqService {}", (Object)e.getLocalizedMessage());
            }
            e.printStackTrace();
            return -1L;
        }
        if (((CqServiceImpl)cqService).isServer()) {
            try {
                FilterProfile fp = cache.getFilterProfile(regionName);
                if (fp != null) return fp.getCqCount();
                return 0L;
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) return 0L;
                logger.debug("Failed to get serverside CQ count for region: {} {}", (Object)regionName, (Object)ex.getLocalizedMessage());
                return 0L;
            }
        } else {
            try {
                CqQuery[] cqs = queryService.getCqs(regionName);
                if (cqs == null) return 0L;
                return cqs.length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    static {
        String statName = "CqServiceStats";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        _type = f.createType(statName, statName, new StatisticDescriptor[]{f.createLongCounter(CQS_CREATED, "Number of CQs created.", "operations"), f.createLongCounter(CQS_ACTIVE, "Number of CQS actively executing.", "operations"), f.createLongCounter(CQS_STOPPED, "Number of CQs stopped.", "operations"), f.createLongCounter(CQS_CLOSED, "Number of CQs closed.", "operations"), f.createLongCounter(CQS_ON_CLIENT, "Number of CQs on the client.", "operations"), f.createLongCounter(CLIENTS_WITH_CQS, "Number of Clients with CQs.", "operations"), f.createLongCounter(CQ_QUERY_EXECUTION_TIME, "Time taken for CQ Query Execution.", "nanoseconds"), f.createLongCounter(CQ_QUERY_EXECUTIONS_COMPLETED, "Number of CQ Query Executions.", "operations"), f.createIntGauge(CQ_QUERY_EXECUTION_IN_PROGRESS, "CQ Query Execution In Progress.", "operations"), f.createIntGauge(UNIQUE_CQ_QUERY, "Number of Unique CQ Querys.", "Queries")});
        _numCqsCreatedId = _type.nameToId(CQS_CREATED);
        _numCqsActiveId = _type.nameToId(CQS_ACTIVE);
        _numCqsStoppedId = _type.nameToId(CQS_STOPPED);
        _numCqsClosedId = _type.nameToId(CQS_CLOSED);
        _numCqsOnClientId = _type.nameToId(CQS_ON_CLIENT);
        _numClientsWithCqsId = _type.nameToId(CLIENTS_WITH_CQS);
        _cqQueryExecutionTimeId = _type.nameToId(CQ_QUERY_EXECUTION_TIME);
        _cqQueryExecutionsCompletedId = _type.nameToId(CQ_QUERY_EXECUTIONS_COMPLETED);
        _cqQueryExecutionInProgressId = _type.nameToId(CQ_QUERY_EXECUTION_IN_PROGRESS);
        _numUniqueCqQuery = _type.nameToId(UNIQUE_CQ_QUERY);
    }
}

