/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceInventory;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.server.DiscoveryConfig;
import io.airlift.discovery.server.DynamicAnnouncementResource;
import io.airlift.discovery.server.DynamicStore;
import io.airlift.discovery.server.ForDynamicStore;
import io.airlift.discovery.server.ForStaticStore;
import io.airlift.discovery.server.ReplicatedDynamicStore;
import io.airlift.discovery.server.ReplicatedStaticStore;
import io.airlift.discovery.server.Service;
import io.airlift.discovery.server.ServiceResource;
import io.airlift.discovery.server.StaticAnnouncementResource;
import io.airlift.discovery.server.StaticStore;
import io.airlift.discovery.store.InMemoryStore;
import io.airlift.discovery.store.PersistentStore;
import io.airlift.discovery.store.PersistentStoreConfig;
import io.airlift.discovery.store.ReplicatedStoreModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.node.NodeInfo;
import java.util.List;
import javax.inject.Singleton;

public class DiscoveryServerModule
implements Module {
    public void configure(Binder binder) {
        ConfigurationModule.bindConfig((Binder)binder).to(DiscoveryConfig.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServiceResource.class);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("discovery");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Service.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(Service.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(DynamicAnnouncementResource.class);
        binder.bind(DynamicStore.class).to(ReplicatedDynamicStore.class).in(Scopes.SINGLETON);
        binder.install((Module)new ReplicatedStoreModule("dynamic", ForDynamicStore.class, InMemoryStore.class));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StaticAnnouncementResource.class);
        binder.bind(StaticStore.class).to(ReplicatedStaticStore.class).in(Scopes.SINGLETON);
        binder.install((Module)new ReplicatedStoreModule("static", ForStaticStore.class, PersistentStore.class));
        ConfigurationModule.bindConfig((Binder)binder).prefixedWith("static").to(PersistentStoreConfig.class);
    }

    @Singleton
    @Provides
    public ServiceSelector getServiceInventory(final ServiceInventory inventory, final NodeInfo nodeInfo) {
        return new ServiceSelector(){

            public String getType() {
                return "discovery";
            }

            public String getPool() {
                return nodeInfo.getPool();
            }

            public List<ServiceDescriptor> selectAllServices() {
                return ImmutableList.copyOf((Iterable)inventory.getServiceDescriptors(this.getType()));
            }

            public ListenableFuture<List<ServiceDescriptor>> refresh() {
                inventory.updateServiceInventory();
                return Futures.immediateFuture(this.selectAllServices());
            }
        };
    }
}

