/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;

public abstract class Store
extends Service {
    private static final Folder[] FOLDER_ARRAY = new Folder[0];
    private List _folderListeners = new LinkedList();
    private List _storeListeners = new LinkedList();

    protected Store(Session session, URLName name) {
        super(session, name);
    }

    public void addFolderListener(FolderListener listener) {
        this._folderListeners.add(listener);
    }

    public void addStoreListener(StoreListener listener) {
        this._storeListeners.add(listener);
    }

    public abstract Folder getDefaultFolder() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract Folder getFolder(URLName var1) throws MessagingException;

    public Folder[] getPersonalNamespaces() throws MessagingException {
        return new Folder[]{this.getDefaultFolder()};
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        return FOLDER_ARRAY;
    }

    public Folder[] getUserNamespaces(String name) throws MessagingException {
        return FOLDER_ARRAY;
    }

    protected void notifyFolderListeners(int type, Folder folder) {
        Iterator it = this._folderListeners.iterator();
        FolderEvent event = new FolderEvent(this, folder, type);
        while (it.hasNext()) {
            FolderListener listener = (FolderListener)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyFolderRenamedListeners(Folder oldFolder, Folder newFolder) {
        Iterator it = this._folderListeners.iterator();
        FolderEvent event = new FolderEvent(this, oldFolder, newFolder, 3);
        while (it.hasNext()) {
            FolderListener listener = (FolderListener)it.next();
            event.dispatch(listener);
        }
    }

    protected void notifyStoreListeners(int type, String message) {
        Iterator it = this._storeListeners.iterator();
        StoreEvent event = new StoreEvent(this, type, message);
        while (it.hasNext()) {
            StoreListener listener = (StoreListener)it.next();
            listener.notification(event);
        }
    }

    public void removeFolderListener(FolderListener listener) {
        this._folderListeners.remove(listener);
    }

    public void removeStoreListener(StoreListener listener) {
        this._storeListeners.remove(listener);
    }
}

