/*
 * Decompiled with CFR 0.152.
 */
package de.felixroske.jfxsupport;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.env.Environment;

public class PropertyReaderHelper {
    private PropertyReaderHelper() {
    }

    public static List<String> get(Environment env, String propName) {
        ArrayList<String> list = new ArrayList<String>();
        String singleProp = env.getProperty(propName);
        if (singleProp != null) {
            list.add(singleProp);
            return list;
        }
        int counter = 0;
        String prop = env.getProperty(propName + "[" + counter + "]");
        while (prop != null) {
            list.add(prop);
            prop = env.getProperty(propName + "[" + ++counter + "]");
        }
        return list;
    }

    public static <T> void setIfPresent(Environment env, String key, Class<T> type, Consumer<T> function) {
        Object value = env.getProperty(key, type);
        if (value != null) {
            function.accept(value);
        }
    }

    public static final String determineFilePathFromPackageName(Class<?> clazz) {
        return "/" + clazz.getPackage().getName().replace('.', '/') + "/";
    }
}

