/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift;

import shaded.parquet.org.apache.thrift.TApplicationException;
import shaded.parquet.org.apache.thrift.TBase;
import shaded.parquet.org.apache.thrift.TException;
import shaded.parquet.org.apache.thrift.protocol.TMessage;
import shaded.parquet.org.apache.thrift.protocol.TProtocol;

public abstract class TServiceClient {
    protected TProtocol iprot_;
    protected TProtocol oprot_;
    protected int seqid_;

    public TServiceClient(TProtocol prot) {
        this(prot, prot);
    }

    public TServiceClient(TProtocol iprot, TProtocol oprot) {
        this.iprot_ = iprot;
        this.oprot_ = oprot;
    }

    public TProtocol getInputProtocol() {
        return this.iprot_;
    }

    public TProtocol getOutputProtocol() {
        return this.oprot_;
    }

    protected void sendBase(String methodName, TBase args) throws TException {
        this.oprot_.writeMessageBegin(new TMessage(methodName, 1, ++this.seqid_));
        args.write(this.oprot_);
        this.oprot_.writeMessageEnd();
        this.oprot_.getTransport().flush();
    }

    protected void receiveBase(TBase result, String methodName) throws TException {
        TMessage msg = this.iprot_.readMessageBegin();
        if (msg.type == 3) {
            TApplicationException x = TApplicationException.read(this.iprot_);
            this.iprot_.readMessageEnd();
            throw x;
        }
        if (msg.seqid != this.seqid_) {
            throw new TApplicationException(4, methodName + " failed: out of sequence response");
        }
        result.read(this.iprot_);
        this.iprot_.readMessageEnd();
    }
}

