/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import parquet.schema.GroupType;
import parquet.schema.InvalidSchemaException;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.TypeVisitor;

public class TypeUtil {
    public static void checkValidWriteSchema(GroupType schema) {
        schema.accept(new TypeVisitor(){

            @Override
            public void visit(GroupType groupType) {
                if (groupType.getFieldCount() <= 0) {
                    throw new InvalidSchemaException("Cannot write a schema with an empty group: " + groupType);
                }
                for (Type type : groupType.getFields()) {
                    type.accept(this);
                }
            }

            @Override
            public void visit(MessageType messageType) {
                this.visit((GroupType)messageType);
            }

            @Override
            public void visit(PrimitiveType primitiveType) {
            }
        });
    }
}

