/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import parquet.CorruptDeltaByteArrays;
import parquet.Log;
import parquet.column.Encoding;
import parquet.filter.UnboundRecordFilter;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.compat.RowGroupFilter;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.InternalParquetRecordReader;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.hadoop.util.counters.BenchmarkCounter;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;

public class ParquetRecordReader<T>
extends RecordReader<Void, T> {
    private static final Log LOG = Log.getLog(ParquetRecordReader.class);
    private final InternalParquetRecordReader<T> internalReader;

    public ParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter) {
        this.internalReader = new InternalParquetRecordReader<T>(readSupport, filter);
    }

    @Deprecated
    public ParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this(readSupport, FilterCompat.get(filter));
    }

    public void close() throws IOException {
        this.internalReader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.internalReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.internalReader.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (context instanceof TaskInputOutputContext) {
            BenchmarkCounter.initCounterFromContext((TaskInputOutputContext)context);
        } else {
            LOG.error("Can not initialize counter due to context is not a instance of TaskInputOutputContext, but is " + context.getClass().getCanonicalName());
        }
        this.initializeInternalReader(this.toParquetSplit(inputSplit), ContextUtil.getConfiguration((JobContext)context));
    }

    public void initialize(InputSplit inputSplit, Configuration configuration, Reporter reporter) throws IOException, InterruptedException {
        BenchmarkCounter.initCounterFromReporter(reporter, configuration);
        this.initializeInternalReader(this.toParquetSplit(inputSplit), configuration);
    }

    private void initializeInternalReader(ParquetInputSplit split, Configuration configuration) throws IOException {
        List<BlockMetaData> filteredBlocks;
        MessageType fileSchema;
        ParquetMetadata footer;
        Path path = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter(configuration, path, ParquetMetadataConverter.range(split.getStart(), split.getEnd()));
            fileSchema = footer.getFileMetaData().getSchema();
            FilterCompat.Filter filter = ParquetInputFormat.getFilter(configuration);
            filteredBlocks = RowGroupFilter.filterRowGroups(filter, footer.getBlocks(), fileSchema);
        } else {
            footer = ParquetFileReader.readFooter(configuration, path, ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            filteredBlocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : footer.getBlocks()) {
                if (!offsets.contains(block.getStartingPos())) continue;
                filteredBlocks.add(block);
            }
            if (filteredBlocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (int i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = footer.getBlocks().get(i).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + filteredBlocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
            }
        }
        if (!filteredBlocks.isEmpty()) {
            this.checkDeltaByteArrayProblem(footer.getFileMetaData(), configuration, filteredBlocks.get(0));
        }
        fileSchema = footer.getFileMetaData().getSchema();
        this.internalReader.initialize(fileSchema, footer.getFileMetaData(), path, filteredBlocks, configuration);
    }

    private void checkDeltaByteArrayProblem(FileMetaData meta, Configuration conf, BlockMetaData block) {
        if (conf.getBoolean("parquet.split.files", true)) {
            HashSet<Encoding> encodings = new HashSet<Encoding>();
            for (ColumnChunkMetaData column : block.getColumns()) {
                encodings.addAll(column.getEncodings());
            }
            for (Encoding encoding : encodings) {
                if (!CorruptDeltaByteArrays.requiresSequentialReads(meta.getCreatedBy(), encoding)) continue;
                throw new ParquetDecodingException("Cannot read data due to PARQUET-246: to read safely, set parquet.split.files to false");
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.internalReader.nextKeyValue();
    }

    private ParquetInputSplit toParquetSplit(InputSplit split) throws IOException {
        if (split instanceof ParquetInputSplit) {
            return (ParquetInputSplit)split;
        }
        if (split instanceof FileSplit) {
            return ParquetInputSplit.from((FileSplit)split);
        }
        if (split instanceof org.apache.hadoop.mapred.FileSplit) {
            return ParquetInputSplit.from((org.apache.hadoop.mapred.FileSplit)split);
        }
        throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplit): " + split);
    }
}

