/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.Tuple;
import com.threerings.user.ExternalAuther;
import com.threerings.user.depot.ExternalAuthRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Singleton
public class ExternalAuthRepository
extends DepotRepository {
    @Inject
    public ExternalAuthRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public int loadUserIdForExternal(ExternalAuther auther, String externalId) {
        Preconditions.checkNotNull((Object)((Object)auther));
        ExternalAuthRecord exrec = (ExternalAuthRecord)this.load(ExternalAuthRecord.getKey(auther, externalId), new QueryClause[0]);
        return exrec == null ? 0 : exrec.userId;
    }

    public String loadExternalIdForUser(ExternalAuther auther, int userId) {
        Preconditions.checkNotNull((Object)((Object)auther));
        ExternalAuthRecord exrec = (ExternalAuthRecord)this.from(ExternalAuthRecord.class).where(new SQLExpression[]{ExternalAuthRecord.USER_ID.eq((Comparable)Integer.valueOf(userId)).and((SQLExpression)ExternalAuthRecord.AUTHER.eq((Comparable)((Object)auther)))}).load();
        return exrec == null ? null : exrec.externalId;
    }

    public String loadExternalSessionKey(ExternalAuther auther, String externalId) {
        Preconditions.checkNotNull((Object)((Object)auther));
        ExternalAuthRecord exrec = (ExternalAuthRecord)this.load(ExternalAuthRecord.getKey(auther, externalId), new QueryClause[0]);
        return exrec == null ? null : exrec.sessionKey;
    }

    public Tuple<String, String> loadExternalAuthInfo(ExternalAuther auther, int userId) {
        Preconditions.checkNotNull((Object)((Object)auther));
        ExternalAuthRecord exrec = (ExternalAuthRecord)this.from(ExternalAuthRecord.class).where(new SQLExpression[]{ExternalAuthRecord.AUTHER.eq((Comparable)((Object)auther)), ExternalAuthRecord.USER_ID.eq((Comparable)Integer.valueOf(userId))}).load();
        return exrec == null ? null : Tuple.newTuple((Object)exrec.externalId, (Object)exrec.sessionKey);
    }

    public Map<String, Integer> loadUserIds(ExternalAuther auther, Collection<String> externalIds) {
        Preconditions.checkNotNull((Object)((Object)auther));
        HashMap ids = Maps.newHashMap();
        for (ExternalAuthRecord exrec : this.from(ExternalAuthRecord.class).where(new SQLExpression[]{ExternalAuthRecord.AUTHER.eq((Comparable)((Object)auther)), ExternalAuthRecord.EXTERNAL_ID.in(externalIds)}).select()) {
            ids.put(exrec.externalId, exrec.userId);
        }
        return ids;
    }

    public Map<Integer, String> loadExternalIds(ExternalAuther auther, Collection<Integer> oooIds) {
        Preconditions.checkNotNull((Object)((Object)auther));
        HashMap ids = Maps.newHashMap();
        for (ExternalAuthRecord exrec : this.from(ExternalAuthRecord.class).where(new SQLExpression[]{ExternalAuthRecord.AUTHER.eq((Comparable)((Object)auther)), ExternalAuthRecord.USER_ID.in(oooIds)}).select()) {
            ids.put(exrec.userId, exrec.externalId);
        }
        return ids;
    }

    public void mapExternalAccount(int userId, ExternalAuther auther, String externalId, String sessionKey) {
        Preconditions.checkNotNull((Object)((Object)auther));
        ExternalAuthRecord exrec = new ExternalAuthRecord();
        exrec.auther = auther;
        exrec.externalId = externalId;
        exrec.userId = userId;
        exrec.sessionKey = sessionKey;
        this.insert(exrec);
    }

    public void updateExternalSession(ExternalAuther auther, String externalId, String sessionKey) {
        Preconditions.checkNotNull((Object)((Object)auther));
        this.updatePartial(ExternalAuthRecord.getKey(auther, externalId), ExternalAuthRecord.SESSION_KEY, sessionKey, new Object[0]);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(ExternalAuthRecord.class);
    }
}

