/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.servlet.SiteIdentifier;
import com.samskivert.servlet.util.CookieUtil;
import com.samskivert.servlet.util.ParameterUtil;
import com.samskivert.util.StringUtil;
import com.threerings.user.AffiliateUtils;
import com.threerings.user.Log;
import com.threerings.user.OOOUserManager;
import com.threerings.user.ReferralRecord;
import com.threerings.user.ReferralRepository;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AffiliateInfo {
    public static final String AFFILIATE_SUFFIX_ATTRIBUTE = AffiliateInfo.class.getName() + ".AffiliateSuffix";
    protected static Pattern _affregex = Pattern.compile("[-._A-Za-z0-9]+");
    protected static final String SITE_REFER_COOKIE = "site_refer";

    public abstract boolean hasName();

    public abstract String getAffiliateName();

    public abstract int getTagId();

    public abstract void addToContext(HttpServletRequest var1);

    public abstract void issueSiteIdCookie(HttpServletRequest var1, HttpServletResponse var2);

    public abstract void issueSiteReferCookie(HttpServletRequest var1, HttpServletResponse var2);

    public abstract void issueAffiliateTagCookie(HttpServletRequest var1, HttpServletResponse var2);

    public boolean isDefaultAffiliate() {
        return false;
    }

    public static AffiliateInfo getAffiliateInfo(OOOUserManager usermgr, ReferralRepository repository, SiteIdentifier identifier, HttpServletRequest req, boolean parseFromParameter) throws PersistenceException {
        int siteId = identifier.identifySite(req);
        return AffiliateInfo.getAffiliateInfo(usermgr, repository, identifier, req, siteId, parseFromParameter);
    }

    public static AffiliateInfo getAffiliateInfo(OOOUserManager usermgr, ReferralRepository repository, SiteIdentifier identifier, HttpServletRequest req, int alternateDefault, boolean parseFromParameter) throws PersistenceException {
        String fromParameter;
        if (null != usermgr.loadUser(req)) {
            return null;
        }
        String string = fromParameter = parseFromParameter ? AffiliateInfo.parseFromParameter(req) : "";
        if (!StringUtil.isBlank((String)fromParameter)) {
            String tagParameter = AffiliateInfo.readAffiliateTag(req);
            int siteId = AffiliateInfo.parseReferrer(repository, identifier, fromParameter);
            if (siteId == 0) {
                Log.log.warning((Object)("User referred by bogus referrer [referrer=" + fromParameter + "]."), new Object[0]);
                return null;
            }
            if (!StringUtil.isBlank((String)tagParameter) && !AffiliateInfo.isPersonalSuffix(fromParameter)) {
                int tagId = usermgr.getAffiliateTagId(tagParameter);
                return new NewReferral(fromParameter, siteId, tagId);
            }
            return new NewReferral(fromParameter, siteId, 0);
        }
        String siteIdCookieValue = AffiliateInfo.readSiteIdCookie(req);
        if (!StringUtil.isBlank((String)siteIdCookieValue)) {
            int tagIdCookieValue = AffiliateInfo.readTagId(req);
            return new CurrentCookies(siteIdCookieValue, tagIdCookieValue);
        }
        String siteReferCookie = CookieUtil.getCookieValue((HttpServletRequest)req, (String)SITE_REFER_COOKIE);
        if (!StringUtil.isBlank((String)siteReferCookie)) {
            int siteId = AffiliateInfo.parseReferrer(repository, identifier, siteReferCookie);
            return new LegacyCookies(siteId, siteReferCookie);
        }
        if (alternateDefault != identifier.identifySite(req)) {
            return new AlternateDefault(alternateDefault);
        }
        int tagIdCookieValue = AffiliateInfo.readTagId(req);
        if (tagIdCookieValue != 0) {
            return new TagOnly(tagIdCookieValue);
        }
        return null;
    }

    public static int parseReferrer(ReferralRepository repository, SiteIdentifier identifier, String referrer) {
        if (StringUtil.isBlank((String)referrer)) {
            return 0;
        }
        if (referrer.matches("r[0-9]+")) {
            int refId = 0;
            try {
                refId = Integer.parseInt(referrer.substring(1));
            }
            catch (NumberFormatException nfe) {
                Log.log.warning((Object)("Bogus user referral: " + referrer), new Object[0]);
                return 0;
            }
            ReferralRecord rec = null;
            try {
                rec = repository.lookupReferral(refId);
                return rec == null ? 2 : -1 * rec.referrerId;
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)("Error looking up referral [ref=" + referrer + ", error=" + (Object)((Object)pe) + "]."), new Object[0]);
                return 0;
            }
        }
        if (referrer.startsWith("user-")) {
            try {
                return -1 * Integer.parseInt(referrer.substring(5));
            }
            catch (NumberFormatException nfe) {
                Log.log.warning((Object)("Bogus user referral: " + referrer), new Object[0]);
                return 0;
            }
        }
        int site = identifier.getSiteId(referrer);
        if (site != -1) {
            return site;
        }
        Log.log.warning((Object)("Bogus site specified in referrer [value=" + referrer + "]."), new Object[0]);
        return 0;
    }

    public static String parseFromParameter(HttpServletRequest req) {
        Matcher am;
        String value = ParameterUtil.getParameter((HttpServletRequest)req, (String)"from", (boolean)true);
        if (value != null && (am = _affregex.matcher(value)).find()) {
            value = am.group();
        }
        return value;
    }

    protected static boolean isPersonalSuffix(String name) {
        return name != null && name.matches("r[0-9]+");
    }

    protected static String readSiteIdCookie(HttpServletRequest req) {
        return CookieUtil.getCookieValue((HttpServletRequest)req, (String)"site_id");
    }

    protected void setAffiliateSuffix(HttpServletRequest req, String referrer, int tagId) {
        if (tagId != 0) {
            req.getSession().setAttribute(AFFILIATE_SUFFIX_ATTRIBUTE, (Object)("-" + referrer + "-" + tagId));
        } else {
            req.getSession().setAttribute(AFFILIATE_SUFFIX_ATTRIBUTE, (Object)("-" + referrer));
        }
        req.getSession().setAttribute(AffiliateUtils.AFFILIATE_ID_ATTRIBUTE, (Object)referrer);
    }

    protected static void giveCookie(HttpServletRequest req, HttpServletResponse rsp, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(2592000);
        cookie.setPath("/");
        CookieUtil.widenDomain((HttpServletRequest)req, (Cookie)cookie);
        rsp.addCookie(cookie);
    }

    protected static String readAffiliateTag(HttpServletRequest req) {
        return req.getParameter("tag");
    }

    protected static int readTagId(HttpServletRequest req) {
        String cookie = CookieUtil.getCookieValue((HttpServletRequest)req, (String)"affiliate_tag");
        if (cookie != null) {
            try {
                return Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    protected static class TagOnly
    extends AffiliateInfo {
        protected final int tagId;

        public TagOnly(int tagId) {
            this.tagId = tagId;
        }

        @Override
        public void addToContext(HttpServletRequest req) {
            this.setAffiliateSuffix(req, "0", this.tagId);
        }

        @Override
        public String getAffiliateName() {
            return "";
        }

        @Override
        public boolean hasName() {
            return false;
        }

        @Override
        public void issueAffiliateTagCookie(HttpServletRequest req, HttpServletResponse rsp) {
            TagOnly.giveCookie(req, rsp, "affiliate_tag", String.valueOf(this.tagId));
        }

        @Override
        public void issueSiteIdCookie(HttpServletRequest req, HttpServletResponse rsp) {
        }

        @Override
        public void issueSiteReferCookie(HttpServletRequest req, HttpServletResponse rsp) {
        }

        @Override
        public int getTagId() {
            return this.tagId;
        }
    }

    protected static class AlternateDefault
    extends AffiliateInfo {
        protected final int site;

        protected AlternateDefault(int site) {
            this.site = site;
        }

        @Override
        public boolean isDefaultAffiliate() {
            return true;
        }

        @Override
        public void addToContext(HttpServletRequest req) {
            this.setAffiliateSuffix(req, "" + this.site, 0);
        }

        @Override
        public String getAffiliateName() {
            return "";
        }

        @Override
        public int getTagId() {
            return 0;
        }

        @Override
        public boolean hasName() {
            return false;
        }

        @Override
        public void issueAffiliateTagCookie(HttpServletRequest req, HttpServletResponse rsp) {
        }

        @Override
        public void issueSiteIdCookie(HttpServletRequest req, HttpServletResponse rsp) {
            AlternateDefault.giveCookie(req, rsp, "site_id", "" + this.site);
        }

        @Override
        public void issueSiteReferCookie(HttpServletRequest req, HttpServletResponse rsp) {
        }
    }

    protected static class LegacyCookies
    extends AffiliateInfo {
        protected final String siteRefer;
        protected final int siteId;

        public LegacyCookies(int siteId, String siteReferCookie) {
            this.siteRefer = siteReferCookie;
            this.siteId = siteId;
        }

        @Override
        public void addToContext(HttpServletRequest req) {
            if (LegacyCookies.isPersonalSuffix(this.siteRefer)) {
                this.setAffiliateSuffix(req, this.siteRefer, 0);
            } else {
                this.setAffiliateSuffix(req, "" + this.siteId, 0);
            }
        }

        @Override
        public String getAffiliateName() {
            if (!LegacyCookies.isPersonalSuffix(this.siteRefer)) {
                return this.siteRefer;
            }
            return "";
        }

        @Override
        public boolean hasName() {
            return !LegacyCookies.isPersonalSuffix(this.siteRefer);
        }

        @Override
        public void issueAffiliateTagCookie(HttpServletRequest req, HttpServletResponse rsp) {
            LegacyCookies.giveCookie(req, rsp, "affiliate_tag", "");
        }

        @Override
        public void issueSiteIdCookie(HttpServletRequest req, HttpServletResponse rsp) {
            if (LegacyCookies.isPersonalSuffix(this.siteRefer)) {
                LegacyCookies.giveCookie(req, rsp, "site_id", this.siteRefer);
            } else {
                LegacyCookies.giveCookie(req, rsp, "site_id", "" + this.siteId);
            }
        }

        @Override
        public void issueSiteReferCookie(HttpServletRequest req, HttpServletResponse rsp) {
            LegacyCookies.giveCookie(req, rsp, AffiliateInfo.SITE_REFER_COOKIE, this.siteRefer);
        }

        @Override
        public int getTagId() {
            return 0;
        }
    }

    protected static class CurrentCookies
    extends AffiliateInfo {
        protected final String siteIdCookieValue;
        protected final int tagIdCookieValue;

        public CurrentCookies(String siteIdCookieValue, int tagIdCookieValue) {
            this.siteIdCookieValue = siteIdCookieValue;
            this.tagIdCookieValue = tagIdCookieValue;
        }

        @Override
        public void addToContext(HttpServletRequest req) {
            this.setAffiliateSuffix(req, this.siteIdCookieValue, this.tagIdCookieValue);
        }

        @Override
        public String getAffiliateName() {
            return null;
        }

        @Override
        public boolean hasName() {
            return false;
        }

        @Override
        public void issueAffiliateTagCookie(HttpServletRequest req, HttpServletResponse rsp) {
            CurrentCookies.giveCookie(req, rsp, "affiliate_tag", "" + this.tagIdCookieValue);
        }

        @Override
        public void issueSiteIdCookie(HttpServletRequest req, HttpServletResponse rsp) {
            CurrentCookies.giveCookie(req, rsp, "site_id", this.siteIdCookieValue);
        }

        @Override
        public void issueSiteReferCookie(HttpServletRequest req, HttpServletResponse rsp) {
            CurrentCookies.giveCookie(req, rsp, AffiliateInfo.SITE_REFER_COOKIE, "");
        }

        @Override
        public int getTagId() {
            return this.tagIdCookieValue;
        }
    }

    protected static class NewReferral
    extends AffiliateInfo {
        protected final String fromParameter;
        protected final int siteId;
        protected final int tagId;

        public NewReferral(String fromParameter, int siteId, int tagId) {
            this.fromParameter = fromParameter;
            this.siteId = siteId;
            this.tagId = tagId;
        }

        @Override
        public void addToContext(HttpServletRequest req) {
            if (NewReferral.isPersonalSuffix(this.fromParameter)) {
                this.setAffiliateSuffix(req, this.fromParameter, this.tagId);
            } else {
                this.setAffiliateSuffix(req, "" + this.siteId, this.tagId);
            }
        }

        @Override
        public String getAffiliateName() {
            return this.fromParameter;
        }

        @Override
        public boolean hasName() {
            return !NewReferral.isPersonalSuffix(this.fromParameter);
        }

        @Override
        public void issueAffiliateTagCookie(HttpServletRequest req, HttpServletResponse rsp) {
            NewReferral.giveCookie(req, rsp, "affiliate_tag", "" + this.tagId);
        }

        @Override
        public void issueSiteIdCookie(HttpServletRequest req, HttpServletResponse rsp) {
            if (NewReferral.isPersonalSuffix(this.fromParameter)) {
                NewReferral.giveCookie(req, rsp, "site_id", this.fromParameter);
            } else {
                NewReferral.giveCookie(req, rsp, "site_id", "" + this.siteId);
            }
        }

        @Override
        public void issueSiteReferCookie(HttpServletRequest req, HttpServletResponse rsp) {
            NewReferral.giveCookie(req, rsp, AffiliateInfo.SITE_REFER_COOKIE, this.fromParameter);
        }

        @Override
        public int getTagId() {
            return this.tagId;
        }
    }
}

