/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Table;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.StringUtil;
import com.threerings.user.AccountAction;
import com.threerings.user.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class AccountActionRepository
extends JORARepository {
    public static final String ACTION_DB_IDENT = "actiondb";
    protected Table<AccountAction> _atable;
    protected boolean _active;
    protected long _lastActionPrune;
    protected static final long ACTION_PRUNE_INTERVAL = 3600000L;
    protected static final String TABLE = "ACCOUNT_ACTIONS";

    public AccountActionRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, ACTION_DB_IDENT);
        this.execute((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                AccountActionRepository.this._active = JDBCUtil.tableExists((Connection)conn, (String)AccountActionRepository.TABLE);
                if (!AccountActionRepository.this._active) {
                    Log.log.info((Object)"No actions table. Disabling.", new Object[0]);
                }
                return null;
            }
        });
    }

    public List<AccountAction> getActions(String server) throws PersistenceException {
        return this.getActions(server, Integer.MAX_VALUE);
    }

    public List<AccountAction> getActions(String server, int maxActions) throws PersistenceException {
        if (!this._active) {
            return new ArrayList<AccountAction>();
        }
        String where = "where ACTION_ID NOT IN (select ACTION_ID from PROCESSED_ACTIONS where SERVER = '" + server + "') limit " + maxActions;
        ArrayList list = this.loadAll(this._atable, where);
        for (AccountAction action : list) {
            action.accountName = JDBCUtil.unjigger((String)action.accountName);
        }
        if (StringUtil.isBlank((String)server)) {
            return list;
        }
        long now = System.currentTimeMillis();
        if (this._lastActionPrune == 0L) {
            this._lastActionPrune = now;
            try {
                this.registerActionServer(server);
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)"Failure registering server", new Object[]{"server", server, pe});
            }
        } else if (now - this._lastActionPrune > 3600000L) {
            this._lastActionPrune = now;
            try {
                this.pruneActions();
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)"Failure auto-pruning actions", new Object[]{"server", server, pe});
            }
        }
        return list;
    }

    public void addAction(String accountName, int action) throws PersistenceException {
        this.addAction(accountName, null, action, "");
    }

    public void addAction(String accountName, String data, int action) throws PersistenceException {
        this.addAction(accountName, data, action, "");
    }

    public void addAction(String accountName, int action, String server) throws PersistenceException {
        this.addAction(accountName, null, action, server);
    }

    public void addAction(String accountName, String data, int action, String server) throws PersistenceException {
        if (!this._active) {
            Log.log.info((Object)"Dropping account action", new Object[]{"name", accountName, "data", data, "action", action, "server", server});
            return;
        }
        AccountAction aact = new AccountAction();
        aact.accountName = JDBCUtil.jigger((String)accountName);
        aact.data = data;
        aact.action = action;
        aact.entered = new Timestamp(System.currentTimeMillis());
        aact.actionId = this.insert(this._atable, aact);
        if (!StringUtil.isBlank((String)server)) {
            this.noteProcessed(aact.actionId, server);
        }
    }

    public void updateAction(AccountAction action, String server) throws PersistenceException {
        this.updateActions(Collections.singletonList(action), server);
    }

    public void updateActions(List<AccountAction> actions, String server) throws PersistenceException {
        int ll = actions.size();
        for (int ii = 0; ii < ll; ++ii) {
            this.noteProcessed(actions.get((int)ii).actionId, server);
        }
    }

    public void deleteAction(final AccountAction action) throws PersistenceException {
        this.delete(this._atable, action);
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                try (Statement stmt = conn.createStatement();){
                    stmt.executeUpdate("delete from PROCESSED_ACTIONS where ACTION_ID = " + action.actionId);
                }
                return null;
            }
        });
    }

    public void noteProcessed(final int actionId, final String server) throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                Statement stmt = conn.createStatement();
                try {
                    String query = "insert into PROCESSED_ACTIONS values(" + actionId + ", '" + server + "')";
                    stmt.executeUpdate(query);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    public void pruneActions() throws PersistenceException {
        final Set<String> servers = this.loadActionServers();
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                HashMap procmap = Maps.newHashMap();
                ArrayIntSet actids = new ArrayIntSet();
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery("select ACTION_ID, SERVER from PROCESSED_ACTIONS");
                    while (rs.next()) {
                        void var8_8;
                        Integer actionId = (Integer)rs.getObject(1);
                        Set set = (Set)procmap.get(actionId);
                        if (set == null) {
                            HashSet hashSet = Sets.newHashSet();
                            procmap.put(actionId, hashSet);
                        }
                        var8_8.add(rs.getString(2));
                    }
                    for (Map.Entry entry : procmap.entrySet()) {
                        Integer actionId = (Integer)entry.getKey();
                        Set procset = (Set)entry.getValue();
                        if (!procset.containsAll(servers)) continue;
                        actids.add(actionId.intValue());
                    }
                    if (actids.size() > 0) {
                        String where = "where ACTION_ID in (" + Joiner.on((String)",").join((Iterable)actids) + ")";
                        stmt.executeUpdate("delete from ACCOUNT_ACTIONS " + where);
                        stmt.executeUpdate("delete from PROCESSED_ACTIONS " + where);
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected void registerActionServer(final String server) throws PersistenceException {
        Set<String> set = this.loadActionServers();
        if (set.contains(server)) {
            return;
        }
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                String query = "insert into ACTION_SERVERS (SERVER) values (?)";
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement(query);
                    stmt.setString(1, server);
                    stmt.executeUpdate();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
            }
        });
        Log.log.info((Object)("Registered action server '" + server + "'."), new Object[0]);
    }

    protected Set<String> loadActionServers() throws PersistenceException {
        return (Set)this.execute((Repository.Operation)new Repository.Operation<Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<String> invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                HashSet set = Sets.newHashSet();
                String query = "select * from ACTION_SERVERS";
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    ResultSet rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        set.add(rs.getString(1));
                    }
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return set;
            }
        });
    }

    protected void createTables() {
        this._atable = new Table(AccountAction.class, TABLE, "ACTION_ID", true);
    }
}

