/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.servlet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.servlet.Site;
import com.samskivert.servlet.SiteIdentifier;
import com.samskivert.util.ArrayUtil;
import com.threerings.servlet.persist.DomainRecord;
import com.threerings.servlet.persist.SiteIdentifierRepository;
import com.threerings.servlet.persist.SiteRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DepotSiteIdentifier
implements SiteIdentifier {
    protected SiteIdentifierRepository _repo;
    protected int _defaultSiteId;
    protected String _defaultSiteString;
    protected volatile List<SiteMapping> _mappings = Lists.newArrayList();
    protected volatile Map<Integer, Site> _sitesById = Maps.newHashMap();
    protected volatile Map<String, Site> _sitesByString = Maps.newHashMap();
    protected long _lastReload;
    protected static final long RELOAD_INTERVAL = 900000L;

    public DepotSiteIdentifier(PersistenceContext pctx) {
        this(pctx, -1);
    }

    public DepotSiteIdentifier(PersistenceContext pctx, int defaultSiteId) {
        this(pctx, defaultSiteId, "default");
    }

    public DepotSiteIdentifier(PersistenceContext pctx, int defaultSiteId, String defaultSiteString) {
        this._repo = new SiteIdentifierRepository(pctx);
        this.refreshSiteData();
        this._defaultSiteId = defaultSiteId;
        this._defaultSiteString = defaultSiteString;
    }

    public int identifySite(HttpServletRequest req) {
        this.checkReloadSites();
        String serverName = req.getServerName();
        int msize = this._mappings.size();
        for (int i = 0; i < msize; ++i) {
            SiteMapping mapping = this._mappings.get(i);
            if (!serverName.endsWith(mapping.domain)) continue;
            return mapping.siteId;
        }
        return this._defaultSiteId;
    }

    public String getSiteString(int siteId) {
        this.checkReloadSites();
        Site site = this._sitesById.get(siteId);
        if (site == null) {
            site = this._sitesById.get(this._defaultSiteId);
        }
        return site == null ? this._defaultSiteString : site.siteString;
    }

    public int getSiteId(String siteString) {
        this.checkReloadSites();
        Site site = this._sitesByString.get(siteString);
        return site == null ? this._defaultSiteId : site.siteId;
    }

    public Iterator<Site> enumerateSites() {
        this.checkReloadSites();
        return this._sitesById.values().iterator();
    }

    public Site insertNewSite(String siteString) {
        return this.insertNewSite(siteString, 0);
    }

    public Site insertNewSite(String siteString, int siteId) {
        if (this._sitesByString.containsKey(siteString) || siteId > 0 && this._sitesById.containsKey(siteId)) {
            return null;
        }
        Site site = this._repo.insertNewSite(siteString, siteId);
        HashMap newStrings = Maps.newHashMap(this._sitesByString);
        HashMap newIds = Maps.newHashMap(this._sitesById);
        newIds.put(site.siteId, site);
        newStrings.put(site.siteString, site);
        this._sitesByString = newStrings;
        this._sitesById = newIds;
        return site;
    }

    public void insertNewDomain(String domain, int siteId) {
        int msize = this._mappings.size();
        for (int i = 0; i < msize; ++i) {
            SiteMapping mapping = this._mappings.get(i);
            if (!mapping.domain.equals(domain)) continue;
            return;
        }
        this._repo.insertNewDomain(domain, siteId);
        ArrayList mappings = Lists.newArrayList();
        mappings.addAll(this._mappings);
        mappings.add(new SiteMapping(siteId, domain));
        Collections.sort(mappings, SiteMapping.BY_SPECIFICITY);
        this._mappings = mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReloadSites() {
        long now = System.currentTimeMillis();
        boolean reload = false;
        DepotSiteIdentifier depotSiteIdentifier = this;
        synchronized (depotSiteIdentifier) {
            boolean bl = reload = now - this._lastReload > 900000L;
            if (reload) {
                this._lastReload = now;
            }
        }
        if (reload) {
            this.refreshSiteData();
        }
    }

    public void refreshSiteData() {
        List<SiteRecord> siteRecords = this._repo.loadSites();
        HashMap sites = Maps.newHashMap();
        HashMap strings = Maps.newHashMap();
        for (SiteRecord record : siteRecords) {
            Site site = record.toSite();
            sites.put(record.siteId, site);
            strings.put(record.siteString, site);
        }
        this._sitesById = sites;
        this._sitesByString = strings;
        List<DomainRecord> domainRecords = this._repo.loadDomains();
        ArrayList mappings = Lists.newArrayList();
        for (DomainRecord record : domainRecords) {
            mappings.add(new SiteMapping(record.siteId, record.domain));
        }
        Collections.sort(mappings, SiteMapping.BY_SPECIFICITY);
        this._mappings = mappings;
    }

    protected static class SiteMapping {
        public static final Comparator<SiteMapping> BY_SPECIFICITY = new Comparator<SiteMapping>(){

            @Override
            public int compare(SiteMapping one, SiteMapping two) {
                return one._rdomain.compareTo(two._rdomain);
            }
        };
        public String domain;
        public int siteId;
        protected String _rdomain;

        public SiteMapping(int siteId, String domain) {
            this.siteId = siteId;
            this.domain = domain;
            byte[] bytes = domain.getBytes();
            ArrayUtil.reverse((byte[])bytes);
            this._rdomain = new String(bytes);
        }

        public String toString() {
            return "[" + this.domain + " => " + this.siteId + "]";
        }
    }
}

