/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.util.Calendars;
import com.samskivert.util.IntIntMap;
import com.threerings.user.depot.ConversionRecord;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class ConversionRepository
extends DepotRepository {
    public static final String CONVERSION_DB_IDENT = "conversiondb";
    protected Map<Date, IntIntMap> _subscribers = Maps.newHashMap();
    protected long _subTime;
    protected long SUB_CACHE_TIME = 3600000L;

    @Inject
    public ConversionRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public ConversionRepository(ConnectionProvider conprov) {
        super(new PersistenceContext(CONVERSION_DB_IDENT, conprov, null));
    }

    public void recordAction(int userId, int siteId, int action) {
        this.recordAction(userId, siteId, action, new Timestamp(System.currentTimeMillis()));
    }

    public void recordAction(int userId, int siteId, int action, Timestamp recorded) {
        ConversionRecord record = new ConversionRecord();
        record.userId = userId;
        record.siteId = siteId;
        record.action = (short)action;
        record.recorded = recorded;
        this.insert(record);
    }

    public IntIntMap getSiteSubscribers(Date date) {
        this.checkRecomputeSubInfo();
        return this._subscribers.get(date);
    }

    public int getTotalSubscribers(Date date) {
        this.checkRecomputeSubInfo();
        return this._subscribers.get(date).get(0);
    }

    public Map<Date, IntIntMap> getSubscriptionInfo() {
        this.checkRecomputeSubInfo();
        return this._subscribers;
    }

    protected void checkRecomputeSubInfo() {
        if (this._subTime + this.SUB_CACHE_TIME < System.currentTimeMillis()) {
            this.computeSubscriptionInfo();
        }
    }

    protected void computeSubscriptionInfo() {
        List data = this.findAll(ConversionRecord.class, new QueryClause[]{new Where((SQLExpression)ConversionRecord.ACTION.in(new Comparable[]{Integer.valueOf(2), Integer.valueOf(3)})), OrderBy.ascending(ConversionRecord.RECORDED)});
        Date recent = null;
        HashSet subs = Sets.newHashSet();
        HashMap siteSubs = Maps.newHashMap();
        HashSet subexcept = Sets.newHashSet();
        HashSet unsubexcept = Sets.newHashSet();
        for (ConversionRecord cr : data) {
            Date day = Calendars.at((Date)cr.recorded).zeroTime().toDate();
            if (recent == null) {
                recent = day;
            } else if (!recent.equals(day)) {
                subexcept.clear();
                unsubexcept.clear();
                this.addSubscriptionEntry(recent, subs, siteSubs);
                recent = day;
            }
            if (!siteSubs.containsKey(cr.getSiteId())) {
                siteSubs.put(cr.getSiteId(), Sets.newHashSet());
            }
            Set siteMap = (Set)siteSubs.get(cr.getSiteId());
            if (cr.action == 2) {
                if (this.checkExcept(unsubexcept, subexcept, subs.contains(cr.userId), cr)) continue;
                subs.add(cr.userId);
                siteMap.add(cr.userId);
                continue;
            }
            if (cr.action != 3 || this.checkExcept(subexcept, unsubexcept, !subs.contains(cr.userId), cr)) continue;
            subs.remove(cr.userId);
            siteMap.remove(cr.userId);
        }
        this.addSubscriptionEntry(Calendars.now().zeroTime().toDate(), subs, siteSubs);
        this._subTime = System.currentTimeMillis();
    }

    protected boolean checkExcept(Set<Integer> expect, Set<Integer> surprise, boolean currentStatus, ConversionRecord cr) {
        if (expect.remove(cr.userId)) {
            return true;
        }
        return currentStatus;
    }

    protected void addSubscriptionEntry(Date day, Set<Integer> subs, Map<Integer, Set<Integer>> siteSubs) {
        IntIntMap daysubs = new IntIntMap();
        for (Map.Entry<Integer, Set<Integer>> entry : siteSubs.entrySet()) {
            Set<Integer> set = entry.getValue();
            int key = entry.getKey();
            daysubs.put(key, set.size());
        }
        daysubs.put(0, subs.size());
        this._subscribers.put(day, daysubs);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(ConversionRecord.class);
    }
}

