/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.samskivert.util.Interval;
import com.threerings.user.Log;

public class LoginThrottle<K> {
    protected int _maxLogins;
    protected Multiset<K> _recentLogins = HashMultiset.create();

    public LoginThrottle(int maxLogins, long period) {
        this._maxLogins = maxLogins;
        new Interval(Interval.RUN_DIRECT){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void expired() {
                Multiset multiset = LoginThrottle.this._recentLogins;
                synchronized (multiset) {
                    LoginThrottle.this._recentLogins.clear();
                }
            }
        }.schedule(period, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean noteLogin(K userIdentifier) {
        Multiset<K> multiset = this._recentLogins;
        synchronized (multiset) {
            int loginCount = 1 + this._recentLogins.add(userIdentifier, 1);
            if (loginCount > this._maxLogins) {
                this.recordThrottledAttempt(userIdentifier, loginCount);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void noteLoginSuccess(K userIdentifier) {
        Multiset<K> multiset = this._recentLogins;
        synchronized (multiset) {
            this._recentLogins.add(userIdentifier, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoginAttemptBlocked(K userIdentifier) {
        int count;
        Multiset<K> multiset = this._recentLogins;
        synchronized (multiset) {
            count = this._recentLogins.count(userIdentifier);
        }
        if (this._maxLogins <= count) {
            this.recordThrottledAttempt(userIdentifier, count);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noteFailedLogin(K userIdentifier) {
        Multiset<K> multiset = this._recentLogins;
        synchronized (multiset) {
            return this._maxLogins <= 1 + this._recentLogins.add(userIdentifier, 1);
        }
    }

    protected void recordThrottledAttempt(K userIdentifier, int loginCount) {
        Log.log.info((Object)"Throttled login attempt", new Object[]{"identifier", userIdentifier, "loginCount", loginCount});
    }
}

