/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.xml.CallMethodSpecialRule;
import com.threerings.media.tile.ObjectTileSet;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.tools.xml.SwissArmyTileSetRuleSet;
import com.threerings.util.DirectionUtil;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTileSetRuleSet
extends SwissArmyTileSetRuleSet {
    @Override
    public void addRuleInstances(Digester digester) {
        super.addRuleInstances(digester);
        digester.addRule(this._path + "/objectWidths", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] widths = StringUtil.parseIntArray((String)bodyText);
                ((ObjectTileSet)target).setObjectWidths(widths);
            }
        });
        digester.addRule(this._path + "/objectHeights", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] heights = StringUtil.parseIntArray((String)bodyText);
                ((ObjectTileSet)target).setObjectHeights(heights);
            }
        });
        digester.addRule(this._path + "/xOrigins", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] xorigins = StringUtil.parseIntArray((String)bodyText);
                ((ObjectTileSet)target).setXOrigins(xorigins);
            }
        });
        digester.addRule(this._path + "/yOrigins", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                int[] yorigins = StringUtil.parseIntArray((String)bodyText);
                ((ObjectTileSet)target).setYOrigins(yorigins);
            }
        });
        digester.addRule(this._path + "/priorities", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                byte[] prios = StringUtil.parseByteArray((String)bodyText);
                ((ObjectTileSet)target).setPriorities(prios);
            }
        });
        digester.addRule(this._path + "/zations", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                String[] zations = StringUtil.parseStringArray((String)bodyText);
                ((ObjectTileSet)target).setColorizations(zations);
            }
        });
        digester.addRule(this._path + "/xspots", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                short[] xspots = StringUtil.parseShortArray((String)bodyText);
                ((ObjectTileSet)target).setXSpots(xspots);
            }
        });
        digester.addRule(this._path + "/yspots", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                short[] yspots = StringUtil.parseShortArray((String)bodyText);
                ((ObjectTileSet)target).setYSpots(yspots);
            }
        });
        digester.addRule(this._path + "/sorients", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                ObjectTileSet set = (ObjectTileSet)target;
                String[] ostrs = StringUtil.parseStringArray((String)bodyText);
                byte[] sorients = new byte[ostrs.length];
                for (int ii = 0; ii < sorients.length; ++ii) {
                    sorients[ii] = (byte)DirectionUtil.fromShortString((String)ostrs[ii]);
                    if (sorients[ii] != -1 || ostrs[ii].equals("-1")) continue;
                    System.err.println("Invalid spot orientation [set=" + set.getName() + ", idx=" + ii + ", orient=" + ostrs[ii] + "].");
                }
                set.setSpotOrients(sorients);
            }
        });
        digester.addRule(this._path + "/constraints", (Rule)new CallMethodSpecialRule(){

            public void parseAndSet(String bodyText, Object target) {
                String[] constrs = StringUtil.parseStringArray((String)bodyText);
                String[][] constraints = new String[constrs.length][];
                for (int ii = 0; ii < constrs.length; ++ii) {
                    constraints[ii] = constrs[ii].split("\\s*\\|\\s*");
                }
                ((ObjectTileSet)target).setConstraints(constraints);
            }
        });
    }

    @Override
    protected Class<? extends TileSet> getTileSetClass() {
        return ObjectTileSet.class;
    }
}

