/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DataSourceConnectionProvider;
import com.samskivert.util.Config;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.postgresql.jdbc2.optional.PoolingDataSource;

public class PostgresUtil {
    public static ConnectionProvider createPoolingProvider(Config config, String ident) {
        final DataSource[] sources = new DataSource[2];
        String[] prefixes = new String[]{"readonly", "readwrite"};
        for (int ii = 0; ii < sources.length; ++ii) {
            Properties props = config.getSubProperties("db.default");
            config.getSubProperties("db." + prefixes[ii], props);
            PoolingDataSource source = new PoolingDataSource();
            source.setDataSourceName(ident + "." + prefixes[ii]);
            source.setServerName(props.getProperty("server"));
            source.setDatabaseName(props.getProperty("database"));
            source.setPortNumber(Integer.parseInt(props.getProperty("port")));
            source.setUser(props.getProperty("username"));
            source.setPassword(props.getProperty("password"));
            source.setMaxConnections(Integer.parseInt(props.getProperty("maxconns", "1")));
            sources[ii] = source;
        }
        return new DataSourceConnectionProvider("jdbc:postgresql", sources[0], sources[1]){
            protected AtomicBoolean _shutdown;
            {
                super(x0, x1, x2);
                this._shutdown = new AtomicBoolean();
            }

            public void shutdown() {
                if (this._shutdown.getAndSet(true)) {
                    return;
                }
                for (DataSource source : sources) {
                    ((PoolingDataSource)source).close();
                }
            }
        };
    }
}

