/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.net.MailUtil;
import com.samskivert.util.Comparators;
import com.samskivert.util.CountHashMap;
import com.threerings.util.ErrorDatabase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.FileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class OOOFileAppender
extends FileAppender {
    protected static final LineFormat STANDARD = new StandardLineFormat();
    protected String _datePattern = "'.'yyyy-MM-dd";
    protected String _database;
    protected String _email;
    protected int _pruneDays;
    protected String _scheduledFilename;
    protected long _nextCheck;
    protected Date _now = new Date();
    protected SimpleDateFormat _sdf;
    protected RollingCalendar _rc = new RollingCalendar();
    protected static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    protected static final int TOP_OF_TROUBLE = -1;
    protected static final int TOP_OF_MINUTE = 0;
    protected static final int TOP_OF_HOUR = 1;
    protected static final int HALF_DAY = 2;
    protected static final int TOP_OF_DAY = 3;
    protected static final int TOP_OF_WEEK = 4;
    protected static final int TOP_OF_MONTH = 5;
    protected static final int LEVEL_OFFSET_IN_STANDARD_LOG_LINE = 24;

    public void setDatePattern(String pattern) {
        this._datePattern = pattern;
    }

    public String getDatePattern() {
        return this._datePattern;
    }

    public void setDatabaseFile(String database) {
        this._database = database;
    }

    public String getDatabaseFile() {
        return this._database;
    }

    public void setEmail(String email) {
        this._email = email;
    }

    public String getEmail() {
        return this._email;
    }

    public void setPruneDays(String days) {
        this._pruneDays = Integer.valueOf(days);
    }

    public String getPruneDays() {
        return String.valueOf(this._pruneDays);
    }

    public void activateOptions() {
        super.activateOptions();
        if (this._datePattern == null || this.fileName == null) {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
            return;
        }
        this._now.setTime(System.currentTimeMillis());
        this._sdf = new SimpleDateFormat(this._datePattern);
        int type = this.computeCheckPeriod();
        this.printPeriodicity(type);
        this._rc.setType(type);
        File file = new File(this.fileName);
        this._scheduledFilename = this.fileName + this._sdf.format(new Date(file.lastModified()));
        if (this._database != null) {
            File dbfile = new File(this._database);
            try {
                dbfile.createNewFile();
            }
            catch (IOException ioe) {
                LogLog.error((String)("Unable to create database file [" + this._database + "]."), (Throwable)ioe);
            }
            if (!dbfile.canWrite()) {
                LogLog.error((String)("Unable to write to database file [" + this._database + "]."));
            }
        }
        if (this._email != null && !MailUtil.isValidAddress((String)this._email)) {
            LogLog.error((String)("Summary email address appears invalid [" + this._email + "]."));
        }
    }

    protected void subAppend(LoggingEvent event) {
        long n = event.getTimeStamp();
        if (n >= this._nextCheck) {
            this._now.setTime(n);
            this._nextCheck = this._rc.getNextCheckMillis(this._now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    protected int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(GMT_TIMEZONE, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this._datePattern != null) {
            for (int ii = 0; ii <= 5; ++ii) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this._datePattern);
                simpleDateFormat.setTimeZone(GMT_TIMEZONE);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(ii);
                Date next = rollingCalendar.getNextCheckDate(epoch);
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return ii;
            }
        }
        return -1;
    }

    protected void rollOver() throws IOException {
        File file;
        if (this._datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this._sdf.format(this._now);
        if (this._scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this._scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if ((file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this._scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename " + this.fileName + " to " + this._scheduledFilename + "."));
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this._scheduledFilename = datedFilename;
        if (this._email != null) {
            try {
                this.summarizeLog(target);
            }
            catch (IOException e) {
                this.errorHandler.error("Failed to summarize " + target, (Exception)e, 0);
            }
        }
        if (this._pruneDays > 0) {
            try {
                this.pruneLogs(new File(this.fileName), System.currentTimeMillis(), this._pruneDays);
            }
            catch (IOException e) {
                this.errorHandler.error("Failed to prune old logs", (Exception)e, 0);
            }
        }
    }

    protected void summarizeLog(File target) throws IOException {
        StringBuilder sumbuf = new StringBuilder();
        this.summarizeLog(target, STANDARD, sumbuf);
        this.sendSummary(sumbuf.toString());
    }

    protected void summarizeLog(File target, LineFormat format, StringBuilder sumbuf) throws IOException {
        ErrorDatabase errors = new ErrorDatabase();
        errors.readFrom(this._database);
        long nowStamp = System.currentTimeMillis();
        this.summarizeLog(target, "Filtered messages", format, errors, nowStamp, sumbuf);
        errors.pruneOldErrors(nowStamp);
        errors.writeTo(this._database);
    }

    protected void summarizeLog(File target, String label, LineFormat format, ErrorDatabase errors, long nowStamp, StringBuilder sumbuf) throws IOException {
        String line;
        CountHashMap counts = new CountHashMap();
        boolean areDisplaying = false;
        int strayLineCount = 0;
        BufferedReader reader = new BufferedReader(new FileReader(target));
        while ((line = reader.readLine()) != null) {
            format.setLine(line);
            if (!format.isImportant()) continue;
            try {
                if (format.isStray()) {
                    if (!areDisplaying) continue;
                    if (strayLineCount >= 100) {
                        areDisplaying = false;
                        sumbuf.append("... (stray lines truncated)\n");
                        continue;
                    }
                    sumbuf.append(line).append("\n");
                    ++strayLineCount;
                    continue;
                }
                areDisplaying = false;
                String level = format.extractLevel();
                if (!level.equals("WARN") && !level.equals("ERROR")) {
                    areDisplaying = false;
                    continue;
                }
                String msgid = format.extractMessageId();
                if (!errors.shouldSummarize(nowStamp, msgid)) {
                    areDisplaying = true;
                    strayLineCount = 0;
                    sumbuf.append(line).append("\n");
                }
                counts.incrementCount((Object)msgid, 1);
            }
            catch (Exception e) {
                LogLog.warn((String)("Summarizer choked on '" + line + "'."), (Throwable)e);
            }
        }
        TreeSet<CountHashMap.Entry<String>> sorted = new TreeSet<CountHashMap.Entry<String>>(new Comparator<CountHashMap.Entry<String>>(){

            @Override
            public int compare(CountHashMap.Entry<String> e1, CountHashMap.Entry<String> e2) {
                int rv = Comparators.compare((int)e2.getCount(), (int)e1.getCount());
                return rv != 0 ? rv : ((String)e1.getKey()).compareTo((String)e2.getKey());
            }
        });
        sorted.addAll(counts.countEntrySet());
        if (sorted.size() > 0) {
            if (sumbuf.length() > 0) {
                sumbuf.append("\n");
            }
            sumbuf.append(label).append(":\n");
            for (CountHashMap.Entry<String> entry : sorted) {
                sumbuf.append(String.format("%3d %s\n", entry.getCount(), entry.getKey()));
            }
        }
    }

    protected void sendSummary(String summary) throws IOException {
        if (summary.length() > 0) {
            String subject = System.getProperty("hostname", "unknown") + " " + this.fileName + " summary";
            try {
                MailUtil.deliverMail((String)this._email, (String)this._email, (String)subject, (String)summary);
            }
            catch (IOException ioe) {
                PrintStream out = System.out;
                String date = new SimpleDateFormat().format(new Date());
                out.println("-- Mail failure @ " + date + "--");
                out.println("Subject: " + subject);
                out.println("Recipient: " + this._email);
                out.println();
                out.println(summary);
                out.println("-- End of summary --");
                throw ioe;
            }
        }
    }

    protected void pruneLogs(final File logFile, long now, int pruneDays) throws IOException {
        if (logFile == null) {
            return;
        }
        long cutoff = now - (long)(pruneDays * 24 * 60 * 60) * 1000L;
        File dir = logFile.getParentFile();
        for (File file : dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(logFile.getName());
            }
        })) {
            long mod = file.lastModified();
            if (mod == 0L) {
                this.errorHandler.error("Unable to get mtime " + file);
                continue;
            }
            if (mod >= cutoff || file.delete()) continue;
            this.errorHandler.error("Unable to delete " + file);
        }
    }

    protected void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    protected static boolean isProbablyStandardLogLine(String line) {
        return line.length() >= 30 && line.charAt(4) == '-' && line.charAt(7) == '-' && line.charAt(13) == ':' && line.charAt(16) == ':' && line.charAt(19) == ',';
    }

    protected static class StandardLineFormat
    implements LineFormat {
        protected String _line;
        protected String _level;
        protected int _bidx;

        protected StandardLineFormat() {
        }

        public void setLine(String line) {
            this._line = line;
            this._level = null;
            this._bidx = -1;
        }

        public boolean isImportant() {
            return true;
        }

        public boolean isStray() {
            return !OOOFileAppender.isProbablyStandardLogLine(this._line);
        }

        public String extractLevel() {
            this._level = this._line.substring(24, 29).trim();
            return this._level;
        }

        public String extractMessageId() {
            int offset = 24 + this._level.length() + 1;
            this._bidx = this._line.indexOf("[", offset);
            if (this._bidx == -1) {
                this._bidx = this._line.length();
            }
            return this._line.substring(offset, this._bidx).trim();
        }
    }

    protected static interface LineFormat {
        public void setLine(String var1);

        public boolean isImportant();

        public boolean isStray();

        public String extractLevel();

        public String extractMessageId();
    }

    protected static class RollingCalendar
    extends GregorianCalendar {
        protected int _type = -1;

        public RollingCalendar() {
        }

        public RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
        }

        public void setType(int type) {
            this._type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this._type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    if (this.get(11) < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

