/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.samskivert.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.TeeOutputStream;
import org.inconspicuous.jsmin.JSMin;

public class JSMinTask
extends Task {
    protected String _dir;
    protected String _output;
    protected List<String> _input = Lists.newArrayList();

    public void setInputs(String input) {
        for (String item : input.split(",")) {
            this._input.add(item.trim());
        }
    }

    public void setOutput(String output) {
        this._output = output;
    }

    public void setInputdir(String dir) {
        this._dir = dir;
    }

    public void execute() throws BuildException {
        Iterable paths = Iterables.transform(this._input, (Function)new Function<String, String>(){

            public String apply(String in) {
                return JSMinTask.this._dir + in;
            }
        });
        final File outFile = new File(this._output);
        Predicate<String> modifiedMoreRecently = new Predicate<String>(){

            public boolean apply(String path) {
                return new File(path).lastModified() > outFile.lastModified();
            }
        };
        if (outFile.exists() && !Iterables.any((Iterable)paths, (Predicate)modifiedMoreRecently)) {
            return;
        }
        this.log("Minifying " + this._input.size() + " files to " + this._output + ".min");
        try {
            OutputStream minout = this.makeGzAndRegularOut(this._output + ".min");
            OutputStream out = this.makeGzAndRegularOut(this._output);
            for (String path : paths) {
                StreamUtil.copy((InputStream)new BufferedInputStream(new FileInputStream(path)), (OutputStream)out);
                new JSMin(new BufferedInputStream(new FileInputStream(path)), minout).jsmin();
            }
            out.close();
            minout.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected OutputStream makeGzAndRegularOut(String path) throws IOException {
        BufferedOutputStream regularOut = new BufferedOutputStream(new FileOutputStream(path));
        GZIPOutputStream gzOut = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(path + ".gz")));
        return new TeeOutputStream((OutputStream)regularOut, (OutputStream)gzOut);
    }
}

