/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Sets;
import com.samskivert.net.MACUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;

public class IdentUtil {
    public static String NO_IDENT;
    protected static Set<String> bogusIdents;
    protected static long TWO_MONTHS;
    protected static String[] WINDOWS_LOCS;
    protected static String[] UNIX_LOCS;
    protected static final int ENCRYPTION_MULTIPLIER = 29;
    protected static final int DECRYPTION_MULTIPLIER = 53;
    protected static byte[] CHAR_TO_BASE_64;
    protected static byte[] BASE_64_TO_CHAR;

    public static String getMachineIdentifier() {
        String ident = IdentUtil.readSecretFile();
        if (!StringUtil.isBlank((String)ident)) {
            return ident;
        }
        try {
            Object[] macs = MACUtil.getMACAddresses();
            if (macs.length > 0) {
                String allMacs = StringUtil.join((Object[])macs);
                ident = StringUtil.md5hex((String)allMacs);
                StringBuilder encoded = new StringBuilder();
                byte[] identArray = IdentUtil.decodeHex(ident);
                byte[] checksum = IdentUtil.computeChecksum(identArray);
                for (int ii = 0; ii < identArray.length; ++ii) {
                    byte value = (byte)(identArray[ii] * 4 + checksum[ii]);
                    value = (byte)(29 * value % 64);
                    encoded.append((char)BASE_64_TO_CHAR[value]);
                }
                ident = encoded.toString();
                IdentUtil.writeSecretFile(ident);
                return ident;
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed creating ident.", new Object[]{e});
        }
        return NO_IDENT;
    }

    public static void main(String[] args) {
        String decoded = args[0];
        if (decoded.length() == 33 && decoded.startsWith("C")) {
            decoded = decoded.substring(1);
        }
        if (decoded.length() != 32) {
            throw new IllegalArgumentException("Incorrect ident length");
        }
        System.out.println(IdentUtil.encodeIdent(decoded));
    }

    public static String encodeIdent(String ident) {
        StringBuilder encoded = new StringBuilder();
        byte[] identArray = IdentUtil.decodeHex(ident);
        byte[] checksum = IdentUtil.computeChecksum(identArray);
        for (int ii = 0; ii < identArray.length; ++ii) {
            byte value = (byte)(identArray[ii] * 4 + checksum[ii]);
            value = (byte)(29 * value % 64);
            encoded.append((char)BASE_64_TO_CHAR[value]);
        }
        return encoded.toString();
    }

    public static String decodeIdent(String encoded) throws Exception {
        if (encoded == null) {
            return null;
        }
        if ((encoded = StringUtil.sanitize((String)encoded, (String)"[A-Za-z0-9/+]")).length() != 32) {
            throw new Exception("Invalid characters or length [encoded=" + encoded + "].");
        }
        StringBuilder decoded = new StringBuilder();
        byte[] checksum = new byte[32];
        char[] characters = encoded.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            byte value = CHAR_TO_BASE_64[characters[ii]];
            value = (byte)(53 * value % 64);
            checksum[ii] = (byte)(value % 4);
            decoded.append(Integer.toHexString(value / 4));
        }
        String ident = decoded.toString();
        String got = new String(checksum);
        String expected = new String(IdentUtil.computeChecksum(IdentUtil.decodeHex(ident)));
        if (!expected.equals(got)) {
            throw new Exception("Checksum failed [ident=" + ident + ", encoded=" + encoded + "].");
        }
        return ident;
    }

    protected static byte[] computeChecksum(byte[] ident) {
        byte[] checksum = new byte[32];
        for (int ii = 0; ii < 16; ++ii) {
            int value = ident[ii] ^ ident[ii + 16];
            checksum[2 * ii] = (byte)(value & 3);
            checksum[2 * ii + 1] = (byte)(value >> 2 & 3);
        }
        return checksum;
    }

    protected static byte[] decodeHex(String ident) {
        char[] characters = ident.toCharArray();
        byte[] values = new byte[characters.length];
        for (int ii = 0; ii < characters.length; ++ii) {
            values[ii] = (byte)Character.digit(characters[ii], 16);
        }
        return values;
    }

    public static void setMachineIdentifier(String ident) {
        IdentUtil.writeSecretFile(ident);
    }

    protected static String readSecretFile() {
        File file = IdentUtil.findSecretFile();
        String ident = null;
        try {
            BufferedReader fin = new BufferedReader(new FileReader(file));
            ident = fin.readLine();
            fin.close();
        }
        catch (Exception e) {
            return null;
        }
        if (ident != null && ident.substring(1).equals(StringUtil.sanitize((String)ident.substring(1), (String)"[a-f0-9]"))) {
            file.delete();
            return null;
        }
        return ident;
    }

    protected static void writeSecretFile(String ident) {
        File file = IdentUtil.findSecretFile();
        try {
            file.delete();
            file.createNewFile();
            BufferedWriter fout = new BufferedWriter(new FileWriter(file));
            fout.write(ident);
            fout.close();
            file.setLastModified(System.currentTimeMillis() - TWO_MONTHS);
            file.setReadOnly();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static File findSecretFile() {
        String[] locs = RunAnywhere.isWindows() ? WINDOWS_LOCS : UNIX_LOCS;
        String homedir = System.getProperty("user.home");
        for (String path : locs) {
            File loc = new File(StringUtil.replace((String)path, (String)"~", (String)homedir));
            try {
                loc.createNewFile();
            }
            catch (IOException e) {
                continue;
            }
            if (!loc.exists()) continue;
            return loc;
        }
        return null;
    }

    public static boolean isBogusIdent(String ident) {
        return bogusIdents.contains(ident);
    }

    static {
        int i;
        NO_IDENT = "ZHNmYWtsd2VxZmprbGpvZGxrc2pmb2lq";
        bogusIdents = Sets.newHashSet((Object[])new String[]{NO_IDENT, "9YKC7D3I6WM6KA6WUKTrmGf69NbT0jHA", "YpUsOXlKg+UgjE/7IGmYRdrTAsHJjiOZ", "MQPUvldivYA5NWPfjD06BvOB04BbNSpW", "H6QKfzaYjIzC3Hvfs3ZyOasRW5rYYjoi", "pepl+wwT8MBilD90Vaky+E0fosM1Ic9A", "STsP+ZW4ZzRb76rQdsLn34gbfqiO4f+F", "BgYVLX2n65LbvJ3qww03sGHM6jx4X42l", "KAHmuTm/KK5JBuU248oU21SltK+0t5Hn", "l2oqxOv/sISNYZSA5zZWrGCXl5boZ3cA", "Dx/CPCIDjYt4NNvoX/UV+TMtXIfiMmV2", "3fQFby4Bvj++pUsIsYM4CwDBvGDFtY4P", "vewfyrMt/ojZp/v5+0ovES/5AvDHz702", "13fN/MCeZLYRJDOQzpOVjTmMqDRcr4IQ", "FOnvFUunXVaWpYqo8V+dEcXPQA9wMj6t", "pGHG2zQaCXiuv9BZ4QiD+Oz7lY31GMpi", "XONdkrW8/Ye3zkJZZHd/SmX1pzsMSeBP", "8uxLC8kg0IxhqKPy5w8uISszAoLxq5AF", "YqXRxbA0aAcY+2Xvy8eu8hlvllJWdiUl", "JAkwPG/evcw93tqNPXyshZbTuLOJPoM9", "chFjoYxmA7NKI4S+sg/ySDxkAPFhycwR", "nDtzsweludiYtMKL2Itb0vwtWkYCyJFt", "di3HZs2/5zA522BsxeUo45RzfWt16185"});
        TWO_MONTHS = 5184000000L;
        WINDOWS_LOCS = new String[]{"C:\\WINDOWS\\Application Data\\Identities\\hash.dat", "C:\\WINDOWS\\Application Data\\hash.dat", "C:\\Documents and Settings\\All Users\\Application\\ Data\\hash.dat", "C:\\Documents and Settings\\All Users\\hash.dat", "C:\\WINNT\\java\\hash.dat", "C:\\WINNT\\hash.dat", "C:\\WINDOWS\\hash.dat", "~\\hash.dat"};
        UNIX_LOCS = new String[]{"~/.mozilla/fonts/.xfs_ath_42", "~/.netscape/archive/.index_42", "~/.galeon/sessions/.sessionAuth_42", "~/.gnome/.sessionAuth_42", "~/.ypp_42", "/tmp/.sess_8475c70a4b3161138aaa4034bb59a005"};
        CHAR_TO_BASE_64 = new byte[255];
        BASE_64_TO_CHAR = new byte[64];
        for (i = 0; i < 255; ++i) {
            IdentUtil.CHAR_TO_BASE_64[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            IdentUtil.CHAR_TO_BASE_64[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            IdentUtil.CHAR_TO_BASE_64[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            IdentUtil.CHAR_TO_BASE_64[i] = (byte)(i - 48 + 52);
        }
        IdentUtil.CHAR_TO_BASE_64[43] = 62;
        IdentUtil.CHAR_TO_BASE_64[47] = 63;
        for (i = 0; i <= 25; ++i) {
            IdentUtil.BASE_64_TO_CHAR[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            IdentUtil.BASE_64_TO_CHAR[i] = (byte)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            IdentUtil.BASE_64_TO_CHAR[i] = (byte)(48 + j);
            ++i;
            ++j;
        }
        IdentUtil.BASE_64_TO_CHAR[62] = 43;
        IdentUtil.BASE_64_TO_CHAR[63] = 47;
    }
}

