/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ErrorDatabase {
    protected Map<String, Error> _errors = Maps.newHashMap();
    protected static final Pattern SPLITTER = Pattern.compile(" ");
    protected static final long DAY_MILLIS = 86400000L;

    public void readFrom(String database) throws IOException {
        String line;
        File dbfile;
        if (database == null || !(dbfile = new File(database)).exists()) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(dbfile));
        while ((line = reader.readLine()) != null) {
            Error error = new Error();
            if (!error.fromLine(line)) continue;
            this._errors.put(error.message, error);
        }
    }

    public void writeTo(String database) throws IOException {
        if (database == null) {
            return;
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(database)));
        for (Error error : this._errors.values()) {
            out.println(error.toLine());
        }
        out.close();
    }

    public void pruneOldErrors(long nowStamp) {
        long cutoff = nowStamp - 604800000L;
        Iterator<Error> iter = this._errors.values().iterator();
        while (iter.hasNext()) {
            Error error = iter.next();
            if (error.mostRecentStamp >= cutoff) continue;
            iter.remove();
        }
    }

    public boolean shouldSummarize(long nowStamp, String message) {
        Error error = this._errors.get(message);
        if (error == null) {
            error = new Error(nowStamp, message);
            this._errors.put(message, error);
        }
        error.mostRecentStamp = nowStamp;
        return nowStamp - error.firstStamp > 259200000L;
    }

    protected static class Error {
        public long firstStamp;
        public long mostRecentStamp;
        public String message;

        public Error() {
        }

        public Error(long now, String message) {
            this.firstStamp = now;
            this.mostRecentStamp = now;
            this.message = message;
        }

        public String toLine() {
            return this.firstStamp + " " + this.mostRecentStamp + " " + this.message;
        }

        public boolean fromLine(String line) {
            try {
                String[] bits = SPLITTER.split(line, 3);
                this.firstStamp = Long.parseLong(bits[0]);
                this.mostRecentStamp = Long.parseLong(bits[1]);
                this.message = bits[2];
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

