/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.threerings.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABTest {
    public static final String DIRECT_AFFILIATE = "(direct)";
    public String id;
    public Set<String> affiliates;
    public Set<String> locales;
    public Set<String> paths = Collections.emptySet();
    public Map<String, Group> groups;
    public boolean allVisitors;
    public Date start;
    public Date end;
    public boolean prefixGroupIdsWithTestId = true;

    public static Map<String, ABTest> loadTests(String path) {
        InputStream in = ABTest.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            Log.log.warning((Object)"Unable to locate abtests on classpath", new Object[]{"path", path});
            return Maps.newHashMap();
        }
        Type abtestsType = new TypeToken<Map<String, ABTest>>(){}.getType();
        Type groupsType = new TypeToken<Map<String, Group>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(abtestsType, (Object)new ABTestMapDeserializer()).registerTypeAdapter(Date.class, (Object)new DateArrayDeserializer()).registerTypeAdapter(groupsType, (Object)new GroupSetDeserializer()).create();
        try {
            return (Map)gson.fromJson((Reader)new InputStreamReader(in, "UTF-8"), abtestsType);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed parsing abtest json", new Object[]{"path", path, e});
            return Maps.newHashMap();
        }
    }

    public boolean isActive() {
        Date now = new Date();
        return !(this.start != null && !this.start.before(now) || this.end != null && !this.end.after(now));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DateArrayDeserializer
    implements JsonDeserializer<Date> {
        protected final Calendar _cal = Calendar.getInstance();

        protected DateArrayDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonArray array = json.getAsJsonArray();
            this._cal.clear();
            this._cal.set(array.get(0).getAsInt(), array.get(1).getAsInt() - 1, array.get(2).getAsInt());
            return this._cal.getTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GroupSetDeserializer
    implements JsonDeserializer<Map<String, Group>> {
        protected GroupSetDeserializer() {
        }

        public Map<String, Group> deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            ArrayList elems;
            if (json.isJsonArray()) {
                JsonArray asArray = json.getAsJsonArray();
                elems = Lists.newArrayListWithCapacity((int)json.getAsJsonArray().size());
                for (JsonElement jsonElement : asArray) {
                    elems.add(jsonElement.getAsJsonObject());
                }
            } else {
                elems = Lists.newArrayList((Object[])new JsonObject[]{json.getAsJsonObject()});
            }
            HashSet current = Sets.newHashSet();
            for (JsonObject components : elems) {
                if (current.isEmpty()) {
                    for (Map.Entry entry : components.entrySet()) {
                        Group g = new Group((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                        g.components.add((String)entry.getKey());
                        current.add(g);
                    }
                    continue;
                }
                HashSet multipliedResult = Sets.newHashSet();
                for (Map.Entry entry : components.entrySet()) {
                    String newId = (String)entry.getKey();
                    String newDescription = ((JsonElement)entry.getValue()).getAsString();
                    for (Group group : current) {
                        Group combined = new Group(group.id + newId, group.description + " " + newDescription);
                        combined.components.add((String)entry.getKey());
                        combined.components.addAll(group.components);
                        multipliedResult.add(combined);
                    }
                }
                current = multipliedResult;
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)current.size());
            for (Group group : current) {
                result.put(group.id, group);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ABTestMapDeserializer
    implements JsonDeserializer<Map<String, ABTest>> {
        protected ABTestMapDeserializer() {
        }

        public Map<String, ABTest> deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            HashMap result = Maps.newHashMap();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                ABTest test = (ABTest)ctx.deserialize((JsonElement)entry.getValue(), ABTest.class);
                test.id = (String)entry.getKey();
                Preconditions.checkArgument((test.groups != null && test.groups.size() > 1 ? 1 : 0) != 0, (Object)(test.id + ".groups must contain at least 2 values"));
                if (test.prefixGroupIdsWithTestId) {
                    HashMap prefixedGroups = Maps.newHashMap();
                    for (Map.Entry<String, Group> group : test.groups.entrySet()) {
                        String prefixed;
                        group.getValue().id = prefixed = test.id + group.getKey();
                        prefixedGroups.put(prefixed, group.getValue());
                    }
                    test.groups = prefixedGroups;
                }
                result.put(entry.getKey(), test);
            }
            return result;
        }
    }

    public static class Group
    implements Cloneable {
        public Set<String> components = Sets.newHashSet();
        public String id;
        public String description;

        public Group(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String toString() {
            return this.id;
        }
    }
}

