/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.Calendars;
import com.threerings.user.depot.ReferralRecord;
import java.sql.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ReferralRepository
extends DepotRepository {
    protected long _lastPurge;
    protected static final long PURGE_INTERVAL = 10800000L;

    @Inject
    public ReferralRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public int recordReferral(int referrerId, String data) {
        ReferralRecord record = new ReferralRecord();
        record.recorded = new Date(System.currentTimeMillis());
        record.referrerId = referrerId;
        record.data = data;
        this.insert(record);
        this.checkPurge();
        return record.referralId;
    }

    public ReferralRecord lookupReferral(int referralId) {
        return (ReferralRecord)this.load(ReferralRecord.getKey(referralId), new QueryClause[0]);
    }

    public ReferralRecord lookupReferrer(int referrerId) {
        return (ReferralRecord)this.load(ReferralRecord.class, new QueryClause[]{new Where(ReferralRecord.REFERRER_ID, (Comparable)Integer.valueOf(referrerId))});
    }

    protected void checkPurge() {
        long now = System.currentTimeMillis();
        if (now - this._lastPurge > 10800000L) {
            this._lastPurge = now;
            this.purgeStaleReferrals();
        }
    }

    protected void purgeStaleReferrals() {
        this.deleteAll(ReferralRecord.class, (WhereClause)new Where((SQLExpression)ReferralRecord.RECORDED.lessThan((Comparable)Calendars.now().zeroTime().addMonths(-1).toSQLDate())));
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(ReferralRecord.class);
    }
}

