/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.expression.SQLExpression;
import com.threerings.user.depot.InvitationRecord;
import java.sql.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class InvitationRepository
extends DepotRepository {
    @Inject
    public InvitationRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public InvitationRecord createInvitationRecord(String email) {
        InvitationRecord rec = new InvitationRecord();
        rec.email = email;
        rec.created = new Date(System.currentTimeMillis());
        for (int ii = 0; ii < 10; ++ii) {
            rec.invitation = Long.toString(Math.abs(new Random().nextLong()), 16);
            try {
                this.insert(rec);
            }
            catch (DuplicateKeyException e) {
                continue;
            }
            return rec;
        }
        return null;
    }

    public InvitationRecord getInvitation(String invitation) {
        return (InvitationRecord)this.load(InvitationRecord.getKey(invitation), new QueryClause[0]);
    }

    public List<InvitationRecord> getInvitationRecords(int start, int count) {
        return this.findAll(InvitationRecord.class, new QueryClause[]{OrderBy.descending((SQLExpression)InvitationRecord.CREATED), new Limit(start, count)});
    }

    public void activateInvitation(InvitationRecord rec, int userId) {
        rec.userId = userId;
        this.update(rec);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(InvitationRecord.class);
    }
}

