/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user.depot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.util.StringUtil;
import com.threerings.user.AccountAction;
import com.threerings.user.Log;
import com.threerings.user.depot.AccountActionRecord;
import com.threerings.user.depot.ActionServerRecord;
import com.threerings.user.depot.ProcessedActionRecord;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AccountActionRepository
extends DepotRepository {
    public static final String ACTION_DB_IDENT = "actiondb";
    protected long _lastActionPrune;
    protected static final long ACTION_PRUNE_INTERVAL = 3600000L;

    @Inject
    public AccountActionRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public AccountActionRepository(ConnectionProvider conprov) {
        super(new PersistenceContext(ACTION_DB_IDENT, conprov, null));
    }

    public List<AccountAction> getActions(String server) {
        return this.getActions(server, Integer.MAX_VALUE);
    }

    public List<AccountAction> getActions(String server, int maxActions) {
        List processed = this.findAll(ProcessedActionRecord.class, new QueryClause[]{new Where((SQLExpression)ProcessedActionRecord.SERVER.eq((Comparable)((Object)server)))});
        ArrayList processedIds = Lists.newArrayListWithCapacity((int)processed.size());
        for (ProcessedActionRecord record : processed) {
            processedIds.add(record.actionId);
        }
        List actions = this.findAll(AccountActionRecord.class, new QueryClause[]{new Where(Ops.not((SQLExpression)AccountActionRecord.ACTION_ID.in((Iterable)processedIds)))});
        ArrayList list = Lists.newArrayListWithCapacity((int)actions.size());
        for (AccountActionRecord record : actions) {
            list.add(record.toAccountAction());
        }
        if (StringUtil.isBlank((String)server)) {
            return list;
        }
        long now = System.currentTimeMillis();
        if (this._lastActionPrune == 0L) {
            this._lastActionPrune = now;
            this.registerActionServer(server);
        } else if (now - this._lastActionPrune > 3600000L) {
            this._lastActionPrune = now;
            this.pruneActions();
        }
        return list;
    }

    public void addAction(String accountName, int action) {
        this.addAction(accountName, null, action, "");
    }

    public void addAction(String accountName, String data, int action) {
        this.addAction(accountName, data, action, "");
    }

    public void addAction(String accountName, int action, String server) {
        this.addAction(accountName, null, action, server);
    }

    public void addAction(String accountName, String data, int action, String server) {
        AccountActionRecord record = new AccountActionRecord();
        record.accountName = accountName;
        record.data = data;
        record.action = action;
        record.entered = new Timestamp(System.currentTimeMillis());
        this.insert(record);
        if (!StringUtil.isBlank((String)server)) {
            this.noteProcessed(record.actionId, server);
        }
    }

    public void updateAction(AccountAction action, String server) {
        this.updateActions(Collections.singletonList(action), server);
    }

    public void updateActions(List<AccountAction> actions, String server) {
        int ll = actions.size();
        for (int ii = 0; ii < ll; ++ii) {
            this.noteProcessed(actions.get((int)ii).actionId, server);
        }
    }

    public void deleteAction(AccountAction action) {
        this.delete(AccountActionRecord.fromAccountAction(action));
        this.deleteAll(ProcessedActionRecord.class, (WhereClause)new Where((SQLExpression)ProcessedActionRecord.ACTION_ID.eq((Comparable)Integer.valueOf(action.actionId))));
    }

    public void noteProcessed(int actionId, String server) {
        ProcessedActionRecord record = new ProcessedActionRecord();
        record.actionId = actionId;
        record.server = server;
        this.insert(record);
    }

    public void pruneActions() {
        Set<String> servers = this.loadActionServers();
        HashMap procmap = Maps.newHashMap();
        HashSet actids = Sets.newHashSet();
        for (ProcessedActionRecord processedActionRecord : this.findAll(ProcessedActionRecord.class, new QueryClause[0])) {
            Set procset = (Set)procmap.get(processedActionRecord.actionId);
            if (procset == null) {
                procset = Sets.newHashSet();
                procmap.put(processedActionRecord.actionId, procset);
            }
            procset.add(processedActionRecord.server);
        }
        for (Map.Entry entry : procmap.entrySet()) {
            if (!((Set)entry.getValue()).containsAll(servers)) continue;
            actids.add(entry.getKey());
        }
        if (actids.size() > 0) {
            this.deleteAll(AccountActionRecord.class, (WhereClause)new Where((SQLExpression)AccountActionRecord.ACTION_ID.in((Iterable)actids)));
            this.deleteAll(ProcessedActionRecord.class, (WhereClause)new Where((SQLExpression)ProcessedActionRecord.ACTION_ID.in((Iterable)actids)));
        }
    }

    protected void registerActionServer(String server) {
        Set<String> set = this.loadActionServers();
        if (set.contains(server)) {
            return;
        }
        ActionServerRecord record = new ActionServerRecord();
        record.server = server;
        this.insert(record);
        Log.log.info((Object)"Registered action server", new Object[]{"server", server});
    }

    protected Set<String> loadActionServers() {
        HashSet set = Sets.newHashSet();
        for (ActionServerRecord record : this.findAll(ActionServerRecord.class, new QueryClause[0])) {
            set.add(record.server);
        }
        return set;
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(AccountActionRecord.class);
        classes.add(ActionServerRecord.class);
        classes.add(ProcessedActionRecord.class);
    }
}

