/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.net.MailUtil;
import com.samskivert.servlet.util.DataValidationException;
import com.samskivert.servlet.util.ParameterUtil;
import com.samskivert.util.StringUtil;
import javax.servlet.http.HttpServletRequest;

public class UserDataUtil {
    public static final int MIN_PASSWORD_LENGTH = 4;
    public static final int MAX_PASSWORD_LENGTH = 12;
    public static final int MIN_USERNAME_LENGTH = 3;
    public static final int MAX_USERNAME_LENGTH = 12;
    protected static final int MAX_EMAIL_LENGTH = 128;
    protected static final int MIN_NAME_LENGTH = 1;
    protected static final int MAX_NAME_LENGTH = 63;
    protected static final int MIN_BIRTHYEAR = 1900;
    protected static final int MIN_BIRTHDATE = 1;
    protected static final int MAX_BIRTHDATE = 31;
    protected static final int MIN_COUNTRY_LENGTH = 2;
    protected static final int MAX_STATE_LENGTH = 64;
    protected static final int MAX_COUNTRY_LENGTH = 64;
    protected static final int MAX_MISSIVE_LENGTH = 32768;

    public static String getUsername(HttpServletRequest req, String page) throws DataValidationException {
        String username = ParameterUtil.requireParameter((HttpServletRequest)req, (String)"username", (String)(page + ".error.missing_username"));
        int len = (username = username.trim()).length();
        if (len < 3 || len > 12 || !username.matches("[a-zA-Z0-9_]+")) {
            throw new DataValidationException(page + ".error.invalid_username");
        }
        return username;
    }

    public static String getPassword(HttpServletRequest req, String page, String ptype) throws DataValidationException {
        String password = ParameterUtil.requireParameter((HttpServletRequest)req, (String)ptype, (String)(page + ".error.missing_" + ptype));
        UserDataUtil.checkPassword(page, password, ptype);
        return password;
    }

    public static void checkPassword(String page, String password, String ptype) throws DataValidationException {
        int len = password.length();
        if (len < 4 || len > 12) {
            throw new DataValidationException(page + ".error.invalid_" + ptype);
        }
    }

    public static String getEmail(HttpServletRequest req, String page, boolean require) throws DataValidationException {
        String email = ParameterUtil.getParameter((HttpServletRequest)req, (String)"email", (boolean)true);
        if (StringUtil.isBlank((String)email)) {
            if (require) {
                throw new DataValidationException(page + ".error.missing_email");
            }
            return "";
        }
        if ((email = email.trim()).length() > 128 || !MailUtil.isValidAddress((String)email)) {
            throw new DataValidationException(page + ".error.invalid_email");
        }
        return email;
    }

    public static String getName(HttpServletRequest req, String page, String pname) throws DataValidationException {
        String name = ParameterUtil.requireParameter((HttpServletRequest)req, (String)pname, (String)(page + ".error.missing_" + pname)).trim();
        int len = name.length();
        if (len < 1 || len > 63 || !name.matches("[a-zA-Z]+")) {
            throw new DataValidationException(page + ".error.invalid_" + pname);
        }
        return name;
    }

    public static String getState(HttpServletRequest req, String page) throws DataValidationException {
        String state = ParameterUtil.getParameter((HttpServletRequest)req, (String)"state", (boolean)false);
        if ((state = state.trim()).length() > 64) {
            throw new DataValidationException(page + ".error.invalid_state");
        }
        return state;
    }

    public static String getCountry(HttpServletRequest req, String page) throws DataValidationException {
        String country = ParameterUtil.requireParameter((HttpServletRequest)req, (String)"country", (String)(page + ".error.missing_country"));
        int len = (country = country.trim()).length();
        if (len < 2 || len > 64) {
            throw new DataValidationException(page + ".error.invalid_country");
        }
        return country;
    }

    public static String getMissive(HttpServletRequest req, String page) throws DataValidationException {
        String missive = ParameterUtil.getParameter((HttpServletRequest)req, (String)"missive", (boolean)false);
        if ((missive = missive.trim()).length() > 32768) {
            throw new DataValidationException(page + ".error.invalid_missive");
        }
        return missive;
    }

    public static byte isChecked(HttpServletRequest req, String name) throws DataValidationException {
        String value = ParameterUtil.getParameter((HttpServletRequest)req, (String)name, (boolean)true);
        return (byte)(value != null ? 1 : 0);
    }

    public static byte requireSelectItem(HttpServletRequest req, String name, String error) throws DataValidationException {
        byte value = (byte)ParameterUtil.getIntParameter((HttpServletRequest)req, (String)name, (int)0, (String)error);
        if (value == 0) {
            throw new DataValidationException(error);
        }
        return value;
    }
}

