/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tracking;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.SimpleRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class TrackingRepository
extends SimpleRepository {
    public static final String TRACKING_TABLE = "TRACKING";
    public static final String TRACKING_DB_IDENT = "trackingdb";

    public TrackingRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, TRACKING_DB_IDENT);
    }

    public void addTrackingEvent(final String event, final String description, final int accountId, final int siteId) throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                PreparedStatement stmt = null;
                try {
                    stmt = conn.prepareStatement("insert into TRACKING (TIME, EVENT, DESCRIPTION, ACCOUNT_ID, SITE_ID) values (NOW(), ?, ?, ?, ?)");
                    stmt.setString(1, event);
                    stmt.setString(2, description);
                    stmt.setInt(3, accountId);
                    stmt.setInt(4, siteId);
                    JDBCUtil.checkedUpdate((PreparedStatement)stmt, (int)1);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        String[] TrackingTable = new String[]{"TIME DATETIME NOT NULL", "EVENT VARCHAR(255)", "DESCRIPTION VARCHAR(255)", "ACCOUNT_ID INTEGER", "SITE_ID INTEGER"};
        JDBCUtil.createTableIfMissing((Connection)conn, (String)TRACKING_TABLE, (String[])TrackingTable, (String)"");
        if (!JDBCUtil.tableContainsColumn((Connection)conn, (String)TRACKING_TABLE, (String)"ACCOUNT_ID")) {
            JDBCUtil.addColumn((Connection)conn, (String)TRACKING_TABLE, (String)"ACCOUNT_ID", (String)"INTEGER", (String)"DESCRIPTION");
            JDBCUtil.addColumn((Connection)conn, (String)TRACKING_TABLE, (String)"SITE_ID", (String)"INTEGER", (String)"ACCOUNT_ID");
        }
    }
}

