/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.survey;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Cursor;
import com.samskivert.jdbc.jora.Table;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMaps;
import com.threerings.survey.SurveyResponse;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurveyRepository
extends JORARepository {
    public static final String SURVEY_DB_IDENT = "surveydb";
    protected Table<SurveyResponse> _stable;

    public SurveyRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, SURVEY_DB_IDENT);
    }

    public List<SurveyResponse> loadResponses(String survey, int userId) throws PersistenceException {
        this.validateSurveyName(survey);
        return this.loadAll(this._stable, "where SURVEY = '" + survey + "' " + "and USER_ID = " + userId);
    }

    public List<String[]> loadResponses(String survey) throws PersistenceException {
        this.validateSurveyName(survey);
        final String where = "where SURVEY = '" + survey + "'";
        return (List)this.execute((Repository.Operation)new Repository.Operation<List<String[]>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<String[]> invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                ArrayList rlist = Lists.newArrayList();
                HashIntMap rmap = IntMaps.newHashIntMap();
                int qcount = 0;
                Statement stmt = conn.createStatement();
                try {
                    SurveyResponse rsp;
                    ResultSet rs = stmt.executeQuery("select MAX(QUESTION) from SURVEYS " + where);
                    if (!rs.next()) {
                        ArrayList arrayList = rlist;
                        return arrayList;
                    }
                    qcount = rs.getInt(1);
                    Cursor c = SurveyRepository.this._stable.select(conn, where);
                    while ((rsp = (SurveyResponse)c.next()) != null) {
                        String[] rvec = (String[])rmap.get(rsp.userId);
                        if (rvec == null) {
                            rvec = new String[qcount];
                            rmap.put(rsp.userId, (Object)rvec);
                        }
                        rvec[rsp.question - 1] = rsp.response;
                    }
                    rlist.addAll(rmap.values());
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return rlist;
            }
        });
    }

    public void storeResponses(List<SurveyResponse> responses) throws PersistenceException {
        int ll = responses.size();
        for (int ii = 0; ii < ll; ++ii) {
            this.store(this._stable, responses.get(ii));
        }
    }

    protected void createTables() {
        this._stable = new Table(SurveyResponse.class, "SURVEYS", new String[]{"SURVEY", "USER_ID", "QUESTION"}, true);
    }

    protected void validateSurveyName(String survey) throws PersistenceException {
        if (!survey.matches("[0-9a-z_]+")) {
            throw new PersistenceException("Invalid survey name '" + survey + "'.");
        }
    }
}

