/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.survey;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.StringUtil;
import com.threerings.survey.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class Survey {
    public String name;
    public String overview;
    public List<Question> questions = Lists.newArrayList();

    public static Survey parseSurvey(String name, InputStream propin) throws IOException {
        Survey survey = new Survey();
        survey.name = name;
        Properties props = new Properties();
        props.load(propin);
        survey.overview = props.getProperty("overview");
        int qcount = 0;
        String val = props.getProperty("questions");
        try {
            qcount = Integer.parseInt(val);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Invalid question count [survey=" + name + ", value=" + val + "]."), new Object[0]);
        }
        for (int ii = 1; ii <= qcount; ++ii) {
            String key = "q" + ii;
            Question q = new Question();
            q.text = props.getProperty(key + ".text");
            q.type = props.getProperty(key + ".type");
            q.units = props.getProperty(key + ".units");
            val = props.getProperty(key + ".choices");
            if (val != null) {
                StringTokenizer tok = new StringTokenizer(val, ",");
                while (tok.hasMoreTokens()) {
                    q.choices.add(tok.nextToken().trim());
                }
            }
            survey.questions.add(q);
        }
        return survey;
    }

    public static class Question {
        public String text;
        public String type;
        public String units;
        public List<String> choices = Lists.newArrayList();

        public int getChoiceCount() {
            if (this.type.equals("yesno")) {
                return 2;
            }
            if (this.type.equals("choice") || this.type.equals("set")) {
                return this.choices.size();
            }
            if (this.type.equals("numeric") || this.type.equals("memo")) {
                return 0;
            }
            Log.log.warning((Object)("Unknown survey question type '" + this.type + "' [text=" + this.text + "]."), new Object[0]);
            return 0;
        }

        public void summarizeResponse(String response, int[] choiceCounts) {
            block2: {
                block4: {
                    block3: {
                        if (!this.type.equals("yesno")) break block3;
                        int n = response.equals("yes") ? 0 : 1;
                        choiceCounts[n] = choiceCounts[n] + 1;
                        break block2;
                    }
                    if (!this.type.equals("choice")) break block4;
                    for (int ii = 0; ii < this.choices.size(); ++ii) {
                        if (!response.equals(this.choices.get(ii))) continue;
                        int n = ii;
                        choiceCounts[n] = choiceCounts[n] + 1;
                        break block2;
                    }
                    break block2;
                }
                if (!this.type.equals("set")) break block2;
                HashSet set = Sets.newHashSet((Object[])StringUtil.split((String)response, (String)", "));
                for (int ii = 0; ii < this.choices.size(); ++ii) {
                    if (!set.contains(this.choices.get(ii))) continue;
                    int n = ii;
                    choiceCounts[n] = choiceCounts[n] + 1;
                }
            }
        }

        public boolean isChosen(String response, String choice) {
            StringTokenizer tok = new StringTokenizer(response, ",");
            while (tok.hasMoreTokens()) {
                if (!tok.nextToken().trim().equals(choice)) continue;
                return true;
            }
            return false;
        }
    }
}

