/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.servlet.persist;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.servlet.Site;
import com.threerings.servlet.persist.DomainRecord;
import com.threerings.servlet.persist.SiteRecord;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SiteIdentifierRepository
extends DepotRepository {
    @Inject
    public SiteIdentifierRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public List<SiteRecord> loadSites() {
        return this.findAll(SiteRecord.class, new QueryClause[0]);
    }

    public List<DomainRecord> loadDomains() {
        return this.findAll(DomainRecord.class, new QueryClause[0]);
    }

    public Site insertNewSite(String siteString) {
        return this.insertNewSite(siteString, 0);
    }

    public Site insertNewSite(String siteString, int siteId) {
        SiteRecord record = new SiteRecord();
        record.siteString = siteString;
        record.siteId = siteId;
        this.insert(record);
        return record.toSite();
    }

    public void insertNewDomain(String domain, int siteId) {
        DomainRecord record = new DomainRecord();
        record.domain = domain;
        record.siteId = siteId;
        this.insert(record);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(DomainRecord.class);
        classes.add(SiteRecord.class);
    }
}

