/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.messaging;

public class DestinationAddress {
    public final String exchange;
    public final String application;
    public final String service;
    public final String command;

    public DestinationAddress(String src) {
        String[] destinationAndExchange = src.split("@");
        String[] routingKey = destinationAndExchange[0].split("\\.");
        this.exchange = destinationAndExchange[1];
        this.application = routingKey[0];
        this.service = routingKey[1];
        this.command = routingKey[2];
    }

    public DestinationAddress(String application, String service, String command, String exchange) {
        this.exchange = exchange;
        this.application = application;
        this.service = service;
        this.command = command;
    }

    public String getRoutingKey() {
        return this.application + '.' + this.service + '.' + this.command;
    }

    public String toString() {
        return this.getRoutingKey() + '@' + this.exchange;
    }

    public boolean equals(Object other) {
        if (other instanceof DestinationAddress) {
            DestinationAddress otherAddress = (DestinationAddress)other;
            return this.exchange.equals(otherAddress.exchange) && this.application.equals(otherAddress.application) && this.service.equals(otherAddress.service) && this.command.equals(otherAddress.command);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

