/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.messaging;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.samskivert.util.Logger;
import com.threerings.messaging.AddressedMessageListener;
import com.threerings.messaging.MessageConnection;
import com.threerings.messaging.MessageSender;
import com.threerings.messaging.NullMessageSender;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class DelayedMessageConnection
implements MessageConnection {
    protected final List<AddressedMessageListener> _impatientListeners = Lists.newArrayList();
    private static final Logger logger = Logger.getLogger(DelayedMessageConnection.class);
    protected final AtomicReference<MessageConnection> _delegate = new AtomicReference<Object>(null);

    public void init(MessageConnection delegate) {
        Preconditions.checkState((boolean)this._delegate.compareAndSet(null, delegate), (Object)"The DelayedMessageConnection was already initialized.");
        for (AddressedMessageListener listener : this._impatientListeners) {
            this._delegate.get().listen(listener);
        }
    }

    public void close() throws IOException {
        MessageConnection delegate = this._delegate.get();
        if (delegate == null) {
            logger.debug((Object)"Closing message connection that was never initialized.", new Object[0]);
        } else {
            delegate.close();
        }
    }

    public MessageSender getSender() {
        MessageConnection delegate = this._delegate.get();
        if (delegate == null) {
            return new NullMessageSender();
        }
        return delegate.getSender();
    }

    public void listen(AddressedMessageListener listener) {
        MessageConnection delegate = this._delegate.get();
        if (delegate == null) {
            logger.info((Object)"Message connection not yet initialized.", new Object[]{"listener", listener});
            this._impatientListeners.add(listener);
        } else {
            delegate.listen(listener);
        }
    }

    public void removeListener(AddressedMessageListener listener) {
        MessageConnection delegate = this._delegate.get();
        if (delegate != null) {
            delegate.removeListener(listener);
        }
    }
}

