/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.kontagent;

import com.google.common.collect.Lists;
import com.samskivert.io.StreamUtil;
import com.samskivert.util.Mapping;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.StringUtil;
import com.threerings.Log;
import com.threerings.kontagent.FeedCampaignInfo;
import com.threerings.kontagent.FeedMessage;
import com.threerings.kontagent.KCall;
import com.threerings.kontagent.KParam;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KontagentLogic {
    protected static final String API_URL_PREFIX = "http://api.geo.kontagent.net/api/v1/";
    protected static final String CAMPAIGN_URL_PREFIX = "http://www.kontagent.com/abtest/campaign_info/";
    protected final String _secretKey;
    protected final String _apiUrl;
    protected final String _campaignUrl;
    protected final Boolean _enabled;
    protected final Executor _exec;
    protected final Random _rando = new Random();
    protected final Map<String, Campaign> _campaigns = new ConcurrentHashMap<String, Campaign>();
    protected static final long FIFTEEN_MINUTES = 900000L;

    public KontagentLogic(String apiKey, String secretKey, boolean enabled) {
        this(apiKey, secretKey, enabled, null);
    }

    public KontagentLogic(String apiKey, String secretKey, boolean enabled, Executor executor) {
        this._apiUrl = API_URL_PREFIX + apiKey;
        this._campaignUrl = CAMPAIGN_URL_PREFIX + apiKey;
        this._secretKey = secretKey;
        this._enabled = enabled;
        this._exec = executor;
    }

    public String generateUniqueId(int forUserId) {
        int now = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
        int rando = this._rando.nextInt();
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.asIntBuffer().put(forUserId).put(now ^ rando);
        return StringUtil.hexlate((byte[])buf.array());
    }

    public void postKontagentMessage(KCall type, Map<KParam, String> params) {
        this.postUrl(this.buildUrl(type, params), type);
    }

    public String getPageRequestImageUrl(String uid) {
        return this.buildUrl(KCall.PAGE_REQUEST, Mapping.of((Object)((Object)KParam.UID), (Object)uid));
    }

    public FeedMessage getCampaignMessage(String campaignName) {
        Campaign campaign = this.fetchCampaign(campaignName);
        if (campaign.messages.isEmpty()) {
            return null;
        }
        int idx = RandomUtil.getWeightedIndex((int[])campaign.weights);
        return campaign.messages.get(idx);
    }

    public Map<KParam, String> generateCampaignSubtypes(String campaign, int msgId, int handleIndex) {
        return Mapping.of((Object)((Object)KParam.SUBTYPE1), (Object)("aB_" + campaign + "___" + handleIndex), (Object)((Object)KParam.SUBTYPE2), (Object)("m" + msgId), (Object)((Object)KParam.SUBTYPE3), (Object)("p" + msgId));
    }

    public int getCampaignHandleIndex(String campaign) {
        return this.fetchCampaign((String)campaign).handleIndex;
    }

    protected Campaign fetchCampaign(String campaignName) {
        Campaign campaign = this._campaigns.get(campaignName);
        if (campaign != null && campaign.created + 900000L > System.currentTimeMillis()) {
            return campaign;
        }
        try {
            String timestamp = "" + System.currentTimeMillis();
            String sig = StringUtil.md5hex((String)("AB_TEST" + timestamp + this._secretKey));
            String url = this._campaignUrl + "/" + campaignName + "/?" + "timestamp=" + timestamp + "&" + "kt_sig=" + sig + "&f=1";
            String jsonString = StreamUtil.toString((InputStream)new URL(url).openStream());
            FeedCampaignInfo info = FeedCampaignInfo.deserialize(jsonString);
            campaign = new Campaign(info.page_and_messages, info.handle_index);
            this._campaigns.put(campaignName, campaign);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Exception encountered fetching campaign info", new Object[]{"campaignName", campaignName, e});
            campaign = new Campaign(Collections.<FeedMessage>emptyList(), 0);
            this._campaigns.put(campaignName, campaign);
        }
        return campaign;
    }

    protected String buildUrl(KCall type, Map<KParam, String> params) {
        params.put(KParam.TIMESTAMP, "" + System.currentTimeMillis());
        ArrayList keys = Lists.newArrayList(params.keySet());
        Collections.sort(keys);
        String initialParams = "";
        for (KParam key : keys) {
            String value = params.get((Object)key);
            if (value == null || value.equals("")) continue;
            initialParams = initialParams + key.getKontagentName() + "=" + value;
        }
        initialParams = initialParams + this._secretKey;
        params.put(KParam.SIGNATURE, StringUtil.md5hex((String)initialParams));
        String url = this._apiUrl + "/" + type.getKontagentName() + "/?";
        Iterator<KParam> iter = params.keySet().iterator();
        while (iter.hasNext()) {
            KParam key = iter.next();
            url = url + key.getKontagentName() + "=" + params.get((Object)key);
            if (!iter.hasNext()) continue;
            url = url + "&";
        }
        return url;
    }

    protected void postUrl(final String url, final KCall type) {
        Runnable poster = new Runnable(){

            public void run() {
                Log.log.info((Object)"prepared kontagent message", new Object[]{"type", type, "url", url, "sending", KontagentLogic.this._enabled});
                if (!KontagentLogic.this._enabled.booleanValue()) {
                    return;
                }
                try {
                    BufferedReader ins = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
                    String line = ins.readLine();
                    if (!"OK".equals(line)) {
                        String text = line;
                        while ((line = ins.readLine()) != null) {
                            text = text + "\n" + line;
                        }
                        Log.log.warning((Object)"Kontagent result not 'OK'", new Object[]{"text", text});
                    }
                    ins.close();
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)"IOException attempting to connect to Kontagent", new Object[]{ioe});
                }
            }
        };
        if (this._exec == null) {
            poster.run();
        } else {
            this._exec.execute(poster);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Campaign {
        public final List<FeedMessage> messages;
        public final int[] weights;
        public final int handleIndex;
        public final long created = System.currentTimeMillis();

        public Campaign(List<FeedMessage> messages, int handleIndex) {
            this.messages = messages;
            this.weights = Campaign.getWeights(messages);
            this.handleIndex = handleIndex;
        }

        protected static int[] getWeights(List<FeedMessage> messages) {
            int[] weights = new int[messages.size()];
            int ii = 0;
            for (FeedMessage message : messages) {
                weights[ii++] = message.weight;
            }
            return weights;
        }
    }
}

