/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook;

import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FQL {
    public static Exp in(final Exp exp, final Collection<Exp> set) {
        return new Exp(){

            public void append(StringBuilder query) {
                exp.append(query);
                query.append(" in (");
                FQL.join(set, query);
                query.append(")");
            }
        };
    }

    public static Exp is(final Exp exp, final String value) {
        return new Exp(){

            public void append(StringBuilder query) {
                exp.append(query);
                query.append(" = ");
                query.append(value);
            }
        };
    }

    public static Exp unquoted(final Object value) {
        return new Exp(){

            public void append(StringBuilder query) {
                query.append(value);
            }
        };
    }

    public static <T extends Exp> void join(Collection<T> items, StringBuilder output) {
        Iterator<T> iter = items.iterator();
        if (iter.hasNext()) {
            ((Exp)iter.next()).append(output);
        }
        while (iter.hasNext()) {
            output.append(", ");
            ((Exp)iter.next()).append(output);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field
    implements Exp {
        public String name;

        public Field(String name) {
            this.name = name;
        }

        @Override
        public void append(StringBuilder query) {
            query.append(this.name);
        }

        public Exp in(Collection<Exp> set) {
            return FQL.in(this, set);
        }

        public Exp is(String value) {
            return FQL.is(this, value);
        }
    }

    public static class And
    implements Exp {
        protected Exp[] _conditions;

        public And(Exp ... conditions) {
            this._conditions = conditions;
        }

        public void append(StringBuilder query) {
            boolean first = true;
            for (Exp condition : this._conditions) {
                if (!first) {
                    query.append(" AND ");
                }
                condition.append(query);
                first = false;
            }
        }
    }

    public static class Where
    implements Clause {
        protected Exp _condition;

        public Where(Exp condition) {
            this._condition = condition;
        }

        public void append(StringBuilder query) {
            query.append("where ");
            this._condition.append(query);
        }
    }

    public static interface Clause {
        public void append(StringBuilder var1);
    }

    public static interface Exp {
        public void append(StringBuilder var1);
    }
}

