/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.convert.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.convert.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrindTrails {
    protected HashSet<String> _starters = new HashSet();
    protected Pattern[] _relevant;
    protected String[] _transitions;
    protected Pattern _success;
    protected Map<String, Node> _nodes = Maps.newHashMap();
    protected Map<String, Session> _sessions = Maps.newHashMap();
    protected Map<String, String> _lastuids = Maps.newHashMap();
    protected SimpleDateFormat _sfmt = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
    protected Pattern _entry = Pattern.compile("(\\S+) \\S+ (\\S+) \\[(.*)\\] \"\\S+ (\\S+) \\S+\" (\\d+) .* \".*\" \".*\"");
    protected Pattern _personal = Pattern.compile("r[0-9]+");

    public GrindTrails(Properties trails) {
        int ii;
        String[] relevant = StringUtil.split((String)trails.getProperty("relevant", ""), (String)",");
        ArrayList patterns = Lists.newArrayList();
        for (ii = 0; ii < relevant.length; ++ii) {
            String pattern = relevant[ii].trim();
            try {
                patterns.add(Pattern.compile(pattern));
                continue;
            }
            catch (Exception e) {
                Log.log.warning((Object)("Invalid relevant URL pattern specified [url=" + pattern + ", error=" + e + "]."), new Object[0]);
            }
        }
        this._relevant = patterns.toArray(new Pattern[patterns.size()]);
        this._transitions = StringUtil.split((String)trails.getProperty("transitions", ".html"), (String)",");
        for (ii = 0; ii < this._transitions.length; ++ii) {
            this._transitions[ii] = this._transitions[ii].trim();
        }
        String[] starters = StringUtil.split((String)trails.getProperty("starters", ""), (String)",");
        for (int ii2 = 0; ii2 < starters.length; ++ii2) {
            String path = starters[ii2].trim();
            if (!this.canTransition(path)) {
                Log.log.warning((Object)("Rejecting start node from which we cannot transition [path=" + path + "]."), new Object[0]);
                continue;
            }
            this._starters.add(path);
        }
        String success = trails.getProperty("success", "").trim();
        try {
            this._success = Pattern.compile(success);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Invalid success pattern specified [pattern=" + success + "]."), new Object[0]);
        }
    }

    public void processLog(String lpath) throws IOException {
        BufferedReader bin = new BufferedReader(this.openReader(lpath));
        String line = null;
        int lines = 0;
        while ((line = bin.readLine()) != null) {
            boolean starter;
            int gpidx;
            String uid;
            ++lines;
            Matcher matcher = this._entry.matcher(line);
            if (!matcher.matches()) continue;
            String uid1 = matcher.group(1);
            String uid2 = matcher.group(2);
            String path = this.canonicalize(matcher.group(4));
            String string = uid = uid1.length() > uid2.length() ? uid1 : uid2;
            if (this.skip(path)) continue;
            int npidx = (path = this._personal.matcher(path).replaceAll("r...")).indexOf("from=neopets");
            if (npidx != -1) {
                path = path.substring(0, npidx + 12);
            }
            if ((gpidx = path.indexOf("from=google1")) != -1) {
                path = path.substring(0, gpidx + 12);
            }
            String ipaddr = uid;
            int ldidx = uid.lastIndexOf(".");
            if (ldidx != -1) {
                ipaddr = uid.substring(0, ldidx);
                uid = uid.substring(ldidx + 1);
            }
            if (starter = this._starters.contains(this.stripQuery(path))) {
                this._lastuids.put(ipaddr, uid);
            } else {
                uid = this._lastuids.get(ipaddr);
            }
            Session sess = this._sessions.get(uid);
            if (sess != null) {
                Node node;
                Node loop = sess.node.checkLoop(path = this.checkRelevance(path));
                if (loop != null) {
                    sess.node = loop;
                    continue;
                }
                if (!this.canTransition(sess.node.path)) {
                    if (sess.node.parent == null) {
                        Log.log.warning((Object)("Can't transition from parentless node!? [path=" + sess.node.path + "]."), new Object[0]);
                    } else {
                        sess.node = sess.node.parent;
                    }
                }
                if ((node = sess.node.children.get(path)) == null) {
                    node = new Node(path, sess.node);
                    sess.node.children.put(path, node);
                }
                node.requesters.add(sess.uid);
                sess.node = node;
                if (!this._success.matcher(node.path).matches()) continue;
                node.getRoot().recordSuccess(sess.uid);
                this._sessions.remove(uid);
                continue;
            }
            if (!starter) continue;
            Node node = this._nodes.get(path);
            if (node == null) {
                node = new Node(path, null);
                this._nodes.put(path, node);
            }
            this._sessions.put(uid, new Session(uid, node));
            node.requesters.add(uid);
        }
        System.out.println("Summary:");
        GrindTrails.dumpNodes(this._nodes.values(), "", false);
        System.out.println("\nDetails:");
        GrindTrails.dumpNodes(this._nodes.values(), "", true);
    }

    protected boolean skip(String path) {
        return path.endsWith(".jpg") || path.endsWith(".gif") || path.endsWith(".png") || path.endsWith(".css") || path.endsWith(".ico");
    }

    protected long parseDate(String when) {
        try {
            return this._sfmt.parse(when.substring(0, 20)).getTime();
        }
        catch (Exception e) {
            Log.log.warning((Object)("Bogus date: " + when), new Object[0]);
            return 0L;
        }
    }

    protected String canonicalize(String path) {
        if (path.endsWith("index.html")) {
            return path.substring(0, path.length() - 10);
        }
        return path;
    }

    protected String stripQuery(String path) {
        int qidx = path.indexOf("?");
        return qidx == -1 ? path : path.substring(0, qidx);
    }

    protected String checkRelevance(String path) {
        for (int ii = 0; ii < this._relevant.length; ++ii) {
            if (!this._relevant[ii].matcher(path).matches()) continue;
            return path;
        }
        return "<elsewhere>";
    }

    protected boolean canTransition(String path) {
        path = this.stripQuery(path);
        for (int ii = 0; ii < this._transitions.length; ++ii) {
            if (!path.endsWith(this._transitions[ii])) continue;
            return true;
        }
        return false;
    }

    protected void increment(Map<Object, int[]> map, Object key) {
        int[] value = map.get(key);
        if (value == null) {
            value = new int[1];
            map.put(key, value);
        }
        value[0] = value[0] + 1;
    }

    protected Reader openReader(String path) throws IOException {
        if (path == null) {
            return new InputStreamReader(System.in);
        }
        if (path.endsWith(".gz")) {
            Process proc = Runtime.getRuntime().exec("gunzip -c " + path);
            return new InputStreamReader(proc.getInputStream());
        }
        return new FileReader(path);
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: GrindTrails trails.properties access.log\n or \nzmergelog access-*.log.gz | GrindTrails trails.properties");
            System.exit(-1);
        }
        Properties trails = new Properties();
        try {
            trails.load(new FileInputStream(args[0]));
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Unable to load trail properties [path=" + args[0] + ", error=" + ioe + "]."), new Object[0]);
            System.exit(-1);
        }
        try {
            GrindTrails stats = new GrindTrails(trails);
            String path = null;
            if (args.length > 1) {
                path = args[1];
            }
            stats.processLog(path);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failure processing stats [path=" + args[1] + "]."), new Object[]{e});
            System.exit(-1);
        }
    }

    protected static void dumpNodes(Collection<Node> nodes, String indent, boolean recurse) {
        Object[] nvec = nodes.toArray(new Node[nodes.size()]);
        Arrays.sort(nvec);
        for (int ii = 0; ii < nvec.length; ++ii) {
            ((Node)nvec[ii]).dump(indent, recurse);
        }
    }

    protected static class Session {
        public String uid;
        public long when;
        public Node node;

        public Session(String uid, Node starter) {
            this.uid = uid;
            this.node = starter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Node
    implements Comparable<Node> {
        public String path;
        public HashSet<String> requesters = new HashSet();
        public HashSet<String> successes;
        public Node parent;
        public Map<String, Node> children = Maps.newHashMap();

        public Node(String path, Node parent) {
            this.path = path;
            this.parent = parent;
        }

        public void recordSuccess(String uid) {
            if (this.successes == null) {
                this.successes = new HashSet();
            }
            this.successes.add(uid);
        }

        public Node checkLoop(String path) {
            if (this.path.equals(path)) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.checkLoop(path);
            }
            return null;
        }

        public Node getRoot() {
            return this.parent == null ? this : this.parent.getRoot();
        }

        @Override
        public int compareTo(Node other) {
            return other.requesters.size() - this.requesters.size();
        }

        public void dump(String indent, boolean recurse) {
            int reqs = this.requesters.size();
            System.out.print(indent + reqs + ": " + this.path);
            if (this.successes != null) {
                int scount = this.successes.size();
                float pct = (float)(1000 * scount / reqs) / 10.0f;
                System.out.println(" -> " + scount + " " + pct + "%");
            } else {
                System.out.println("");
            }
            if (recurse) {
                indent = indent + "  ";
                GrindTrails.dumpNodes(this.children.values(), indent, recurse);
            }
        }
    }
}

