/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.convert.tools;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.StaticConnectionProvider;
import com.samskivert.servlet.JDBCTableSiteIdentifier;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.CollectionUtil;
import com.samskivert.util.Config;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.StringUtil;
import com.threerings.convert.Log;
import com.threerings.convert.server.persist.InstallRecord;
import com.threerings.convert.server.persist.InstallRepository;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrindInstallStats {
    protected int _bogus;
    protected HashIntMap<ClientGroup> _groups = new HashIntMap();
    protected Map<String, ClientGroup> _ipmap = Maps.newHashMap();
    protected CountMap<Date> _dates = new CountMap();
    protected CountMap<String> _failedIdents = new CountMap();
    protected InstallRepository _instrepo;
    protected JDBCTableSiteIdentifier _siteid;
    protected Date _summaryDate;
    protected SimpleDateFormat _sfmt = new SimpleDateFormat("dd/MMM/yyyy");
    protected ArrayIntSet _installerSizes = new ArrayIntSet();
    protected Map<String, String> _lastuid = Maps.newHashMap();
    protected static boolean _verbose = !StringUtil.isBlank((String)System.getProperty("verbose"));
    protected static Pattern _lpat = Pattern.compile("^(\\S+) \\S+ \\S+ \\[\\S+ \\S+\\] \"(\\S+)( .* )HTTP\\S*\" (\\S+) (\\S+) .*");
    protected static Pattern _refaff = Pattern.compile("r[0-9]+");
    protected static Pattern _normaff = Pattern.compile("[-._A-Za-z0-9]+");
    protected static final String[][] PATHS = new String[][]{{" / ", "/index.xhtml", "/index.html", "/register/welcome.wm", "/miniclip/mclanding.xhtml"}, {"/download.xhtml", "/register/download.wm", "/launch.xhtml", "/miniclip/mclaunch.xhtml", "/miniclip/mcdownload.xhtml"}, {"-install.", "fullinstall"}, {"/install_start.txt"}, {"/java.zip"}, {"/install_end.txt"}, {"/getdown.txt"}, {"rsrc/config/resource/manager.properties"}};

    public GrindInstallStats(ConnectionProvider conprov) throws PersistenceException {
        this._instrepo = new InstallRepository(conprov, null);
        this._siteid = new JDBCTableSiteIdentifier(conprov);
    }

    public void processLog(String path) throws IOException {
        BufferedReader bin = new BufferedReader(this.openReader(path));
        String line = null;
        int lines = 0;
        int dlines = 0;
        while ((line = bin.readLine()) != null) {
            int ldidx;
            ++lines;
            boolean match = false;
            block7: for (int ii = 0; ii < PATHS.length; ++ii) {
                for (int jj = 0; jj < PATHS[ii].length; ++jj) {
                    if (line.indexOf(PATHS[ii][jj]) == -1) continue;
                    match = true;
                    continue block7;
                }
            }
            if (!match) continue;
            Matcher m = _lpat.matcher(line);
            if (!m.matches()) {
                ++this._bogus;
                continue;
            }
            String method = m.group(2);
            if (!method.equals("GET")) continue;
            String upath = m.group(3);
            int phase = -1;
            block9: for (int ii = 0; ii < PATHS.length; ++ii) {
                for (int jj = 0; jj < PATHS[ii].length; ++jj) {
                    if (upath.indexOf(PATHS[ii][jj]) == -1) continue;
                    phase = ii;
                    continue block9;
                }
            }
            if (phase == -1) continue;
            if (++dlines % 100 == 99) {
                try {
                    String date = StringUtil.split((String)line, (String)" ")[3];
                    date = date.substring(1, 12);
                    this._dates.increment(new Date(this._sfmt.parse(date).getTime()));
                }
                catch (Exception e) {
                    Log.log.info((Object)("Choke! " + line + "/" + e), new Object[0]);
                }
            }
            String ipaddr = m.group(1);
            String rcode = m.group(4);
            int size = 0;
            try {
                size = Integer.parseInt(m.group(5));
            }
            catch (Exception e) {
                if (m.group(5).equals("-")) continue;
                Log.log.warning((Object)("Failed to parse size '" + m.group(5) + "': " + line), new Object[0]);
                continue;
            }
            String uid = ipaddr;
            if (ipaddr.length() > 15 && (ldidx = ipaddr.lastIndexOf(".")) != -1) {
                uid = ipaddr.substring(ldidx + 1);
                ipaddr = ipaddr.substring(0, ldidx);
            }
            if (phase <= 2) {
                this._lastuid.put(ipaddr, uid);
            } else {
                uid = this._lastuid.get(ipaddr);
            }
            ClientGroup group = null;
            if (phase == 0) {
                int ident;
                int fidx = upath.indexOf("from=");
                if (upath.indexOf("miniclip") != -1) {
                    ident = 30;
                } else if (fidx == -1) {
                    ident = 2;
                } else {
                    String affstr = upath.substring(fidx + 5);
                    Matcher am = _normaff.matcher(affstr);
                    if (am.find()) {
                        affstr = am.group();
                    }
                    if ((ident = _refaff.matcher(affstr).matches() ? 7 : this._siteid.getSiteId(affstr)) < 0) {
                        Log.log.warning((Object)("Unknown landing affiliate [affstr=" + affstr + "]."), new Object[0]);
                        continue;
                    }
                }
                group = (ClientGroup)this._groups.get(ident);
                if (group == null) {
                    group = new ClientGroup(ident);
                    this._groups.put(ident, (Object)group);
                }
                this._ipmap.put(uid, group);
            } else if (phase == 2) {
                int didx;
                String idstr = upath;
                int pos = idstr.indexOf("?");
                if (pos != -1) {
                    idstr = idstr.substring(0, pos);
                }
                if (idstr.indexOf("yotools") != -1 || idstr.indexOf("devclient") != -1 || idstr.indexOf("aclient") != -1) continue;
                pos = idstr.indexOf("yohoho-");
                if (pos != -1) {
                    idstr = idstr.substring(pos + 7);
                }
                if (idstr.startsWith("install.") || idstr.indexOf("puzzlepirates-fullinstall.") != -1) {
                    idstr = String.valueOf(2);
                } else {
                    pos = idstr.indexOf("-install.");
                    if (pos != -1) {
                        idstr = idstr.substring(0, pos);
                    }
                }
                if (idstr.startsWith("r")) {
                    idstr = String.valueOf(7);
                }
                if (idstr.equals("sw")) {
                    idstr = "3";
                }
                if ((didx = idstr.indexOf("-")) != -1) {
                    idstr = idstr.substring(0, didx);
                }
                int ident = 2;
                try {
                    if (idstr.length() > 0) {
                        ident = Integer.parseInt(idstr);
                    }
                }
                catch (Exception e) {
                    this._failedIdents.increment(upath);
                }
                if (ident < 0) {
                    ident = 7;
                }
                if ((group = (ClientGroup)this._groups.get(ident)) == null) {
                    group = new ClientGroup(ident);
                    this._groups.put(ident, (Object)group);
                }
                this._ipmap.put(uid, group);
            } else {
                group = this._ipmap.get(uid);
                if (group == null) continue;
            }
            group.process(uid, rcode, upath, phase, size);
        }
        int count = 0;
        for (Date when : this._dates.keySet()) {
            int wcount = ((int[])this._dates.get(when))[0];
            if (wcount <= count) continue;
            this._summaryDate = when;
            count = wcount;
        }
        if (_verbose) {
            Log.log.info((Object)("Processed " + lines + " in '" + path + "'."), new Object[0]);
        }
    }

    public void summarize() {
        if (_verbose) {
            Log.log.info((Object)("Unparseable lines: " + this._bogus), new Object[0]);
        }
        int[] keys = new int[this._groups.size()];
        int idx = 0;
        for (Integer key : this._groups.keySet()) {
            keys[idx++] = key;
        }
        Arrays.sort(keys);
        for (int ii = 0; ii < keys.length; ++ii) {
            ClientGroup group = (ClientGroup)this._groups.get(keys[ii]);
            InstallRecord irec = group.summarize();
            if (_verbose) {
                Log.log.info((Object)("* " + irec), new Object[0]);
            }
            try {
                this._instrepo.delete(irec.siteId, irec.summaryDate);
                this._instrepo.record(irec);
                continue;
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)pe, new Object[0]);
            }
        }
        for (Map.Entry entry : this._failedIdents.entrySet()) {
            Log.log.info((Object)("Faield to parse '" + (String)entry.getKey() + "': " + ((int[])entry.getValue())[0]), new Object[0]);
        }
        if (_verbose) {
            Log.log.info((Object)("Accepted sizes: " + this._installerSizes), new Object[0]);
        }
    }

    protected Reader openReader(String path) throws IOException {
        if (path == null) {
            return new InputStreamReader(System.in);
        }
        if (path.endsWith(".gz")) {
            Process proc = Runtime.getRuntime().exec("gunzip -c " + path);
            return new InputStreamReader(proc.getInputStream());
        }
        return new FileReader(path);
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: GrindInstallStats database.properties access.log\n or \nzmergelog access-*.log.gz | GrindInstallStats database.properties");
            System.exit(-1);
        }
        Config config = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(args[0]));
            config = new Config("grind_install_stats", props);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Unable to load database properties [path=" + args[0] + ", error=" + ioe + "]."), new Object[0]);
            System.exit(-1);
        }
        StaticConnectionProvider conprov = new StaticConnectionProvider(config.getSubProperties("db"));
        GrindInstallStats stats = null;
        try {
            stats = new GrindInstallStats((ConnectionProvider)conprov);
            String path = null;
            if (args.length > 1) {
                path = args[1];
            }
            stats.processLog(path);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failure processing stats [path=" + args[1] + "]."), new Object[]{e});
            System.exit(-1);
        }
        stats.summarize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientGroup {
        protected int _ident;
        protected HashIntMap<CountMap<String>> _phases = new HashIntMap();
        protected CountMap<String> _resumers = new CountMap();
        protected HashIntMap<CountMap<String>> _initials = new HashIntMap();

        public ClientGroup(int ident) {
            this._ident = ident;
            for (int ii = 0; ii < PATHS.length; ++ii) {
                this._phases.put(ii, new CountMap());
            }
        }

        public void process(String uid, String rcode, String upath, int phase, int size) {
            if (!(rcode.startsWith("2") || phase == 0 && rcode.startsWith("3"))) {
                return;
            }
            if (phase == 2) {
                CountMap<String> map = (CountMap<String>)this._initials.get(size);
                if (map == null) {
                    map = new CountMap<String>();
                    this._initials.put(size, map);
                }
                map.increment(uid);
                if (rcode.equals("206")) {
                    this._resumers.increment(uid);
                }
            }
            ((CountMap)this._phases.get(phase)).increment(uid);
        }

        public InstallRecord summarize() {
            InstallRecord irec = new InstallRecord();
            irec.siteId = this._ident;
            irec.summaryDate = GrindInstallStats.this._summaryDate;
            irec.landed = ((CountMap)this._phases.get(0)).size();
            irec.viewedDownload = ((CountMap)this._phases.get(1)).size();
            irec.installerStart = ((CountMap)this._phases.get(2)).size();
            irec.installerHello = ((CountMap)this._phases.get(3)).size();
            irec.downloadedJava = ((CountMap)this._phases.get(4)).size();
            irec.installerGoodbye = ((CountMap)this._phases.get(5)).size();
            irec.getdownStart = ((CountMap)this._phases.get(6)).size();
            irec.getdownFinish = ((CountMap)this._phases.get(7)).size();
            HashSet getters = new HashSet();
            for (Map.Entry entry : this._initials.entrySet()) {
                int size = (Integer)entry.getKey();
                CountMap map = (CountMap)entry.getValue();
                if ((map.size() <= 10 || map.size() < irec.installerStart / 5) && !GrindInstallStats.this._installerSizes.contains(size)) continue;
                CollectionUtil.addAll(getters, map.keySet().iterator());
                GrindInstallStats.this._installerSizes.add(size);
            }
            CollectionUtil.addAll(getters, this._resumers.keySet().iterator());
            irec.installerGot = getters.size();
            return irec;
        }

        public String toString() {
            return "" + this._ident;
        }

        protected <K> void summarize(CountMap<K> map) {
            for (Map.Entry entry : map.entrySet()) {
                Log.log.info((Object)(" " + entry.getKey() + " -> " + ((int[])entry.getValue())[0]), new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CountMap<K>
    extends HashMap<K, int[]> {
        public int getCount(K key) {
            return ((int[])this.get(key))[0];
        }

        public void increment(K key) {
            int[] value = (int[])this.get(key);
            if (value == null) {
                value = new int[1];
                this.put(key, value);
            }
            value[0] = value[0] + 1;
        }
    }
}

