/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.convert.server.persist;

import com.google.common.collect.Lists;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Table;
import com.samskivert.util.HashIntMap;
import com.threerings.convert.server.persist.InstallRecord;
import com.threerings.user.OOOUserRepository;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallRepository
extends JORARepository {
    public static final String INSTALL_DB_IDENT = "installdb";
    protected Table<InstallRecord> _itable;
    protected OOOUserRepository _ooorepo;

    public InstallRepository(ConnectionProvider provider, OOOUserRepository ooorepo) throws PersistenceException {
        super(provider, INSTALL_DB_IDENT);
        this._ooorepo = ooorepo;
    }

    public void record(InstallRecord record) throws PersistenceException {
        this.store(this._itable, record);
    }

    public void delete(int siteId, Date date) throws PersistenceException {
        String query = "delete from INSTALLS where SITE_ID = " + siteId + " and SUMMARY_DATE = '" + date + "'";
        this.update(query);
    }

    public List<InstallRecord> loadInstallData(int siteId, Date from, Date to) throws PersistenceException {
        String query;
        List<InstallRecord> data = null;
        if (siteId > 0) {
            query = "where SITE_ID = " + siteId + " and SUMMARY_DATE >= '" + from + "'" + " and SUMMARY_DATE <= '" + to + "' order by SUMMARY_DATE";
            data = this.loadAll(this._itable, query);
        } else {
            query = "select SUMMARY_DATE, SUM(LANDED), SUM(VIEWED_DOWNLOAD), SUM(INSTALLER_START), SUM(INSTALLER_GOT), SUM(INSTALLER_HELLO), SUM(DOWNLOADED_JAVA), SUM(INSTALLER_GOODBYE), SUM(GETDOWN_START), SUM(GETDOWN_FINISH) from INSTALLS where SUMMARY_DATE >= '" + from + "' and " + "SUMMARY_DATE <= '" + to + "' " + "group by SUMMARY_DATE order by SUMMARY_DATE";
            data = (List)this.execute((Repository.Operation)new Repository.Operation<List<InstallRecord>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<InstallRecord> invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                    Statement stmt = null;
                    ArrayList records = Lists.newArrayList();
                    try {
                        stmt = conn.createStatement();
                        ResultSet rs = stmt.executeQuery(query);
                        while (rs.next()) {
                            InstallRecord rec = new InstallRecord();
                            rec.summaryDate = rs.getDate(1);
                            rec.landed = rs.getInt(2);
                            rec.viewedDownload = rs.getInt(3);
                            rec.installerStart = rs.getInt(4);
                            rec.installerGot = rs.getInt(5);
                            rec.installerHello = rs.getInt(6);
                            rec.downloadedJava = rs.getInt(7);
                            rec.installerGoodbye = rs.getInt(8);
                            rec.getdownStart = rs.getInt(9);
                            rec.getdownFinish = rs.getInt(10);
                            records.add(rec);
                        }
                    }
                    finally {
                        JDBCUtil.close((Statement)stmt);
                    }
                    return records;
                }
            });
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        Date current = null;
        int ii = 0;
        do {
            current = new Date(cal.getTime().getTime());
            InstallRecord rec = null;
            if (ii < data.size()) {
                rec = (InstallRecord)data.get(ii);
            }
            if (rec == null || !rec.summaryDate.equals(current)) {
                InstallRecord filler = new InstallRecord();
                filler.siteId = siteId;
                filler.summaryDate = current;
                filler.installerStart = 1;
                data.add(ii, filler);
            }
            cal.add(5, 1);
            ++ii;
        } while (!current.equals(to));
        if (this._ooorepo != null && data.size() > 0) {
            HashIntMap<int[]> rstats = this._ooorepo.getAffiliateRegistrationHistory(data.get((int)0).summaryDate, data.get((int)(data.size() - 1)).summaryDate);
            if (siteId > 0) {
                this.recordRegistrations(data, (int[])rstats.get(siteId));
            } else {
                for (int[] element : rstats.values()) {
                    this.recordRegistrations(data, element);
                }
            }
        }
        return data;
    }

    protected void recordRegistrations(List<InstallRecord> records, int[] regs) {
        if (regs != null) {
            for (int ii = 0; ii < regs.length; ++ii) {
                records.get((int)ii).registrations += regs[ii];
            }
        }
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"INSTALLS", (String[])new String[]{"SITE_ID SMALLINT NOT NULL", "SUMMARY_DATE DATE NOT NULL", "LANDED INTEGER NOT NULL", "VIEWED_DOWNLOAD INTEGER NOT NULL", "INSTALLER_START INTEGER NOT NULL", "INSTALLER_GOT INTEGER NOT NULL", "STEP_ONE INTEGER NOT NULL", "STEP_TWO INTEGER NOT NULL", "STEP_THREE INTEGER NOT NULL", "PRIMARY KEY (SUMMARY_DATE, SITE_ID)"}, (String)"");
        if (JDBCUtil.tableContainsColumn((Connection)conn, (String)"INSTALLS", (String)"STEP_ONE")) {
            JDBCUtil.changeColumn((Connection)conn, (String)"INSTALLS", (String)"STEP_ONE", (String)"DOWNLOADED_JAVA INTEGER NOT NULL");
            JDBCUtil.changeColumn((Connection)conn, (String)"INSTALLS", (String)"STEP_TWO", (String)"GETDOWN_START INTEGER NOT NULL");
            JDBCUtil.changeColumn((Connection)conn, (String)"INSTALLS", (String)"STEP_THREE", (String)"GETDOWN_FINISH INTEGER NOT NULL");
            JDBCUtil.addColumn((Connection)conn, (String)"INSTALLS", (String)"INSTALLER_HELLO", (String)"INTEGER NOT NULL", (String)"INSTALLER_GOT");
            JDBCUtil.addColumn((Connection)conn, (String)"INSTALLS", (String)"INSTALLER_GOODBYE", (String)"INTEGER NOT NULL", (String)"DOWNLOADED_JAVA");
        }
    }

    protected void createTables() {
        this._itable = new Table(InstallRecord.class, "INSTALLS", new String[]{"SITE_ID", "SUMMARY_DATE"}, true);
    }
}

