/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server;

import com.samskivert.depot.PersistenceContext;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.RepositoryListenerUnit;
import com.samskivert.jdbc.ResultUnit;
import com.samskivert.jdbc.WriteOnlyUnit;
import com.samskivert.util.AuditLogger;
import com.samskivert.util.Calendars;
import com.samskivert.util.IntResultListener;
import com.samskivert.util.Interval;
import com.samskivert.util.Invoker;
import com.samskivert.util.ResultListener;
import com.threerings.coin.Log;
import com.threerings.coin.server.persist.CoinRepository;
import com.threerings.coin.server.persist.DailySummary;
import com.threerings.user.depot.AccountActionRepository;
import java.sql.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoinManager {
    public static final String SERVER_ACCOUNT_NAME = "@@SERVER@@";
    protected CoinRepository _coinRepo;
    protected Invoker _invoker;
    protected static final long COIN_HISTORY_FREQ = 21600000L;

    public CoinManager(ConnectionProvider conprov, String serverId, AuditLogger auditLogger, AccountActionRepository accountActionRepo, Invoker invoker) {
        this(conprov, serverId, auditLogger, accountActionRepo, invoker, true);
    }

    public CoinManager(ConnectionProvider conprov, String serverId, AuditLogger auditLogger, AccountActionRepository accountActionRepo, Invoker invoker, boolean runCoinSummary) {
        this(new PersistenceContext("coindb", conprov, null), serverId, auditLogger, accountActionRepo, invoker, runCoinSummary);
    }

    public CoinManager(PersistenceContext ctx, String serverId, AuditLogger auditLogger, AccountActionRepository accountActionRepo, Invoker invoker, boolean runCoinSummary) {
        this._coinRepo = new CoinRepository(ctx, serverId, auditLogger, accountActionRepo);
        this._invoker = invoker;
        this._coinRepo.unreserveAllCoinsForThisServer();
        if (!runCoinSummary) {
            return;
        }
        new Interval(){

            public void expired() {
                CoinManager.this._invoker.postUnit((Invoker.Unit)new WriteOnlyUnit("CoinManager:summarizeCoinHistory"){

                    public void invokePersist() throws Exception {
                        CoinManager.this.summarizeCoinHistory();
                    }
                });
            }
        }.schedule(21600000L, true);
    }

    public CoinRepository getCoinRepository() {
        return this._coinRepo;
    }

    public void getCoinSnapshot(final String accountName, final IntResultListener rl) {
        this._invoker.postUnit((Invoker.Unit)new ResultUnit<Integer>("CoinManager:getCoinSnapshot"){

            public Integer computeResult() throws Exception {
                return CoinManager.this._coinRepo.getCoinCount(accountName);
            }

            public void handleResult(Integer result) {
                rl.requestCompleted(result.intValue());
            }

            public void handleFailure(Exception e) {
                rl.requestFailed(e);
            }
        });
    }

    public void reserveCoins(final String accountName, final int coins, final IntResultListener rl) {
        if (coins < 1) {
            rl.requestFailed((Exception)new IllegalArgumentException("" + coins));
            return;
        }
        this._invoker.postUnit((Invoker.Unit)new ResultUnit<Integer>("CoinManager:reserveCoins"){

            public Integer computeResult() throws Exception {
                return CoinManager.this._coinRepo.reserveCoins(accountName, coins);
            }

            public void handleResult(Integer result) {
                if (result == -1) {
                    rl.requestFailed((Exception)new InsufficientFundsException());
                } else {
                    rl.requestCompleted(result.intValue());
                }
            }

            public void handleFailure(Exception e) {
                rl.requestFailed(e);
            }
        });
    }

    public void transferReservation(final int reservationId, final String destAccountName, final int type, final String srcDescrip, final String destDescrip, ResultListener<Void> rl) {
        this._invoker.postUnit((Invoker.Unit)new RepositoryListenerUnit<Void>("CoinManager:transferReservation", rl){

            public Void invokePersistResult() throws Exception {
                if (!CoinManager.this._coinRepo.transferCoins(reservationId, destAccountName, type, srcDescrip, destDescrip)) {
                    throw new Exception("No such reservation.");
                }
                return null;
            }
        });
    }

    public void spendReservation(final int reservationId, final int type, final String descrip, ResultListener<Void> rl) {
        this._invoker.postUnit((Invoker.Unit)new RepositoryListenerUnit<Void>("CoinManager:spendReservation", rl){

            public Void invokePersistResult() throws Exception {
                if (!CoinManager.this._coinRepo.spendCoins(reservationId, type, descrip)) {
                    throw new Exception("No such reservation.");
                }
                return null;
            }
        });
    }

    public void returnReservation(final int reservationId, ResultListener<Void> rl) {
        this._invoker.postUnit((Invoker.Unit)new RepositoryListenerUnit<Void>("CoinManager:returnReservation", rl){

            public Void invokePersistResult() throws Exception {
                if (!CoinManager.this._coinRepo.returnReservation(reservationId)) {
                    throw new Exception("No such reservation.");
                }
                return null;
            }
        });
    }

    public void purchase(final String accountName, final int coins, final int type, final String descrip, final CoinOp op, final ResultListener<Object> rl) {
        this.reserveCoins(accountName, coins, new IntResultListener(){

            public void requestFailed(Exception cause) {
                rl.requestFailed(cause);
            }

            public void requestCompleted(final int reservationId) {
                try {
                    op.processPurchase(new ResultListener<Object>(){

                        public void requestCompleted(Object result) {
                            CoinManager.this.finalizePurchase(reservationId, result, type, descrip, (ResultListener<Object>)rl);
                        }

                        public void requestFailed(Exception cause) {
                            CoinManager.this.rollbackPurchase(reservationId, cause, (ResultListener<Object>)rl);
                        }
                    });
                }
                catch (Exception booch) {
                    Log.log.warning((Object)"Error processing purchase", new Object[]{"accountName", accountName, "coins", coins, booch});
                    CoinManager.this.rollbackPurchase(reservationId, booch, (ResultListener<Object>)rl);
                }
            }
        });
    }

    protected void rollbackPurchase(final int reservationId, final Exception cause, final ResultListener<Object> rl) {
        this._invoker.postUnit(new Invoker.Unit("CoinManager:rollbackPurchase"){

            public boolean invoke() {
                try {
                    if (!CoinManager.this._coinRepo.returnReservation(reservationId)) {
                        Log.log.warning((Object)("Holy crap! Unable to unreserve coins, what the hell happened to them? [reservationId=" + reservationId + "]."), new Object[0]);
                    }
                }
                catch (Exception pe) {
                    Log.log.warning((Object)("Oh crap! Exception while attempting to rollback a coin purchase [reservationId=" + reservationId + ", error=" + pe + "]."), new Object[0]);
                }
                return true;
            }

            public void handleResult() {
                rl.requestFailed(cause);
            }
        });
    }

    protected void finalizePurchase(final int reservationId, final Object result, final int type, final String descrip, final ResultListener<Object> rl) {
        this._invoker.postUnit(new Invoker.Unit("CoinManager:finalizePurchase"){

            public boolean invoke() {
                try {
                    if (!CoinManager.this._coinRepo.spendCoins(reservationId, type, descrip)) {
                        Log.log.warning((Object)("Holy crap! Unable to spend spent coins, what the hell happened to them? [reservationId=" + reservationId + "]."), new Object[0]);
                    }
                }
                catch (Exception pe) {
                    Log.log.warning((Object)("Oh crap! Exception while attempting to finalize a coin purchase, looks like they got the goods for free [reservationId=" + reservationId + "]."), new Object[]{pe});
                }
                return true;
            }

            public void handleResult() {
                rl.requestCompleted(result);
            }
        });
    }

    protected void summarizeCoinHistory() {
        Date yest = Calendars.now().addDays(-1).toSQLDate();
        try {
            List<DailySummary> histo = this._coinRepo.loadHistory(yest, yest);
            if (histo.isEmpty()) {
                this._coinRepo.summarizeHistory(yest, yest);
            }
            this._coinRepo.pruneTransactions();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Choked while summarizing coin history.", new Object[]{e});
        }
    }

    public static class InsufficientFundsException
    extends Exception {
        public InsufficientFundsException() {
            super("Insufficient Funds");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CoinOp {
        public void processPurchase(ResultListener<Object> var1);
    }
}

