/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.clientstep;

import com.samskivert.util.StringUtil;
import com.threerings.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class TrackingUtil {
    protected static String _uid;
    public static String _csid;
    public static String _urlBase;

    public static void init(String uid, String csid, String urlBase) {
        _uid = uid;
        _csid = csid;
        _urlBase = urlBase;
    }

    public static void track(String event, String description) {
        if (!StringUtil.isBlank((String)_uid)) {
            TrackingUtil.track(description, _urlBase + event, _urlBase);
        }
    }

    public static void track(String description, String url, String referrer) {
        if (!StringUtil.isBlank((String)_uid)) {
            String args = "0d" + _csid + "&" + StringUtil.encode((String)description) + "&" + StringUtil.encode((String)url) + "&" + StringUtil.encode((String)referrer);
            String target = "http://www.instadia.net/cgi-bin/gather?" + args;
            TrackingUtil.loadURL(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadURL(String target) {
        Log.log.info((Object)("Loading tracking URL [url=" + target + "]."), new Object[0]);
        HttpURLConnection conn = null;
        try {
            URL url = new URL(target);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Cookie", "UID=" + _uid);
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new IOException("HTTP code " + code);
            }
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Failed to load tracking URL [url=" + target + ", e=" + ioe + "]."), new Object[0]);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

