/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    protected final Segment[] _segs;
    protected final Mustache.Compiler _compiler;
    protected final Map<Key, VariableFetcher> _fcache = new ConcurrentHashMap<Key, VariableFetcher>();
    protected static final VariableFetcher MAP_FETCHER = new VariableFetcher(){

        public Object get(Object ctx, String name) throws Exception {
            return ((Map)ctx).get(name);
        }
    };
    protected static final VariableFetcher THIS_FETCHER = new VariableFetcher(){

        public Object get(Object ctx, String name) throws Exception {
            return ctx;
        }
    };
    protected static final Object NO_FETCHER_FOUND = new Object();
    protected static final String DOT_NAME = ".".intern();
    protected static final String THIS_NAME = "this".intern();
    protected static final String FIRST_NAME = "-first".intern();
    protected static final String LAST_NAME = "-last".intern();
    protected static final String INDEX_NAME = "-index".intern();

    public String execute(Object context) throws MustacheException {
        StringWriter out = new StringWriter();
        this.execute(context, out);
        return out.toString();
    }

    public void execute(Object context, Writer out) throws MustacheException {
        this.executeSegs(new Context(context, null, 0, false, false), out);
    }

    protected Template(Segment[] segs, Mustache.Compiler compiler) {
        this._segs = segs;
        this._compiler = compiler;
    }

    protected void executeSegs(Context ctx, Writer out) throws MustacheException {
        for (Segment seg : this._segs) {
            seg.execute(this, ctx, out);
        }
    }

    protected Object getValue(Context ctx, String name, int line, boolean missingIsNull) {
        if (!this._compiler.standardsMode && name != DOT_NAME && name.indexOf(DOT_NAME) != -1) {
            String[] comps = name.split("\\.");
            Object data = this.getValue(ctx, comps[0].intern(), line, missingIsNull);
            for (int ii = 1; ii < comps.length; ++ii) {
                if (data == NO_FETCHER_FOUND) {
                    throw new NullPointerException("Missing context for compound variable '" + name + "' on line " + line + ". '" + comps[ii - 1] + "' was not found.");
                }
                if (data == null) {
                    throw new NullPointerException("Null context for compound variable '" + name + "' on line " + line + ". '" + comps[ii - 1] + "' resolved to null.");
                }
                data = this.getValueIn(data, comps[ii].intern(), line);
            }
            return this.checkForMissing(name, line, missingIsNull, data);
        }
        if (name == FIRST_NAME) {
            return ctx.onFirst;
        }
        if (name == LAST_NAME) {
            return ctx.onLast;
        }
        if (name == INDEX_NAME) {
            return ctx.index;
        }
        if (this._compiler.standardsMode) {
            return this.checkForMissing(name, line, missingIsNull, this.getValueIn(ctx.data, name, line));
        }
        boolean variableMissing = true;
        while (ctx != null) {
            Object value = this.getValueIn(ctx.data, name, line);
            if (value != NO_FETCHER_FOUND) {
                if (value == null) {
                    variableMissing = false;
                } else {
                    return value;
                }
            }
            ctx = ctx.parent;
        }
        return this.checkForMissing(name, line, missingIsNull, variableMissing ? NO_FETCHER_FOUND : null);
    }

    protected Object getSectionValue(Context ctx, String name, int line) {
        Object value = this.getValue(ctx, name, line, this._compiler.missingIsNull);
        return value == null ? Collections.emptyList() : value;
    }

    protected Object getValueOrDefault(Context ctx, String name, int line) {
        Object value = this.getValue(ctx, name, line, this._compiler.missingIsNull);
        return value == null ? this._compiler.nullValue : value;
    }

    protected Object getValueIn(Object data, String name, int line) {
        if (data == null) {
            throw new NullPointerException("Null context for variable '" + name + "' on line " + line);
        }
        Key key = new Key(data.getClass(), name);
        VariableFetcher fetcher = this._fcache.get(key);
        if (fetcher != null) {
            try {
                return fetcher.get(data, name);
            }
            catch (Exception e) {
                fetcher = Template.createFetcher(key);
            }
        } else {
            fetcher = Template.createFetcher(key);
        }
        if (fetcher == null) {
            return NO_FETCHER_FOUND;
        }
        try {
            Object value = fetcher.get(data, name);
            this._fcache.put(key, fetcher);
            return value;
        }
        catch (Exception e) {
            throw new MustacheException("Failure fetching variable '" + name + "' on line " + line, e);
        }
    }

    protected Object checkForMissing(String name, int line, boolean missingIsNull, Object value) {
        if (value == NO_FETCHER_FOUND) {
            if (missingIsNull) {
                return null;
            }
            throw new MustacheException("No method or field with name '" + name + "' on line " + line);
        }
        return value;
    }

    protected static VariableFetcher createFetcher(Key key) {
        if (key.name == DOT_NAME || key.name == THIS_NAME) {
            return THIS_FETCHER;
        }
        if (Map.class.isAssignableFrom(key.cclass)) {
            return MAP_FETCHER;
        }
        final Method m = Template.getMethod(key.cclass, key.name);
        if (m != null) {
            return new VariableFetcher(){

                public Object get(Object ctx, String name) throws Exception {
                    return m.invoke(ctx, new Object[0]);
                }
            };
        }
        final Field f = Template.getField(key.cclass, key.name);
        if (f != null) {
            return new VariableFetcher(){

                public Object get(Object ctx, String name) throws Exception {
                    return f.get(ctx);
                }
            };
        }
        return null;
    }

    protected static Method getMethod(Class<?> clazz, String name) {
        Method m;
        try {
            m = clazz.getDeclaredMethod(name, new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            m = clazz.getDeclaredMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]);
            if (!m.getReturnType().equals(Void.TYPE)) {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Class<?> sclass = clazz.getSuperclass();
        if (sclass != Object.class && sclass != null) {
            return Template.getMethod(clazz.getSuperclass(), name);
        }
        return null;
    }

    protected static Field getField(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return f;
        }
        catch (Exception e) {
            Class<?> sclass = clazz.getSuperclass();
            if (sclass != Object.class && sclass != null) {
                return Template.getField(clazz.getSuperclass(), name);
            }
            return null;
        }
    }

    protected static abstract class VariableFetcher {
        protected VariableFetcher() {
        }

        abstract Object get(Object var1, String var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Key {
        public final Class<?> cclass;
        public final String name;

        public Key(Class<?> cclass, String name) {
            this.cclass = cclass;
            this.name = name;
        }

        public int hashCode() {
            return this.cclass.hashCode() * 31 + this.name.hashCode();
        }

        public boolean equals(Object other) {
            Key okey = (Key)other;
            return okey.cclass == this.cclass && okey.name == this.name;
        }
    }

    protected static abstract class Segment {
        protected Segment() {
        }

        abstract void execute(Template var1, Context var2, Writer var3);

        protected static void write(Writer out, String data) {
            try {
                out.write(data);
            }
            catch (IOException ioe) {
                throw new MustacheException(ioe);
            }
        }
    }

    protected static class Context {
        public final Object data;
        public final Context parent;
        public final int index;
        public final boolean onFirst;
        public final boolean onLast;

        public Context(Object data, Context parent, int index, boolean onFirst, boolean onLast) {
            this.data = data;
            this.parent = parent;
            this.index = index;
            this.onFirst = onFirst;
            this.onLast = onLast;
        }

        public Context nest(Object data, int index, boolean onFirst, boolean onLast) {
            return new Context(data, this, index, onFirst, onLast);
        }
    }
}

