/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.jalico;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Threads {
    private final List<Runner> runners = new ArrayList<Runner>();
    private final Semaphore semaphore = new Semaphore(0);
    private boolean fired = false;
    private boolean started = false;
    private List<ActionListener> actionListeners;

    Threads() {
    }

    public synchronized <T extends Runnable> T add(T runnable) {
        if (this.started) {
            throw new IllegalThreadStateException("Cannot add another runnable to " + this.getClass().getSimpleName() + " after it started !");
        }
        this.runners.add(new Runner(runnable));
        return runnable;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalThreadStateException(this.getClass().getSimpleName() + " already started !");
        }
        if (this.runners.isEmpty()) {
            throw new NoSuchElementException("No runnable were added to this " + this.getClass().getSimpleName());
        }
        for (Runner t : this.runners) {
            t.start();
        }
        this.started = true;
    }

    public synchronized void interrupt() {
        if (!this.started) {
            throw new IllegalThreadStateException(this.getClass().getSimpleName() + " not started !");
        }
        for (Runner t : this.runners) {
            try {
                t.interrupt();
            }
            catch (IllegalThreadStateException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void join() throws InterruptedException {
        int nThreads = this.runners.size();
        if (nThreads == 0) {
            return;
        }
        if (!this.started) {
            this.start();
        }
        this.semaphore.acquire(nThreads);
        this.semaphore.release(nThreads);
    }

    public synchronized State getState() {
        int nThreads = this.runners.size();
        if (nThreads == 0) {
            return State.NoRunnables;
        }
        if (!this.started) {
            return State.NotStarted;
        }
        if (this.semaphore.tryAcquire(nThreads)) {
            this.semaphore.release(nThreads);
            return State.Finished;
        }
        return State.Running;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(actionListener);
        if (this.fired) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    private synchronized void fireActionPerformed() {
        if (this.actionListeners == null) {
            return;
        }
        ActionEvent a = new ActionEvent(this, 1001, "");
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NotStarted,
        Running,
        Finished,
        NoRunnables;

    }

    private class Runner
    extends Thread {
        private final Runnable runnable;

        public Runner(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block6: {
                Runner runner;
                try {
                    this.runnable.run();
                    Object var2_1 = null;
                    int nThreads = Threads.this.runners.size();
                    if (!Threads.this.semaphore.tryAcquire(nThreads - 1)) break block6;
                    Threads.this.semaphore.release(nThreads);
                    runner = this;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    int nThreads = Threads.this.runners.size();
                    if (Threads.this.semaphore.tryAcquire(nThreads - 1)) {
                        Threads.this.semaphore.release(nThreads);
                        Runner runner2 = this;
                        synchronized (runner2) {
                            if (Threads.this.fired) throw throwable;
                            Threads.this.fired = true;
                            Threads.this.fireActionPerformed();
                            throw throwable;
                        }
                    }
                    Threads.this.semaphore.release();
                    throw throwable;
                }
                synchronized (runner) {
                    if (Threads.this.fired) return;
                    Threads.this.fired = true;
                    Threads.this.fireActionPerformed();
                    return;
                }
            }
            Threads.this.semaphore.release();
        }
    }
}

