/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.jalico;

import com.nativelibs4java.jalico.CollectionEvent;
import com.nativelibs4java.jalico.CollectionListener;
import com.nativelibs4java.jalico.ListenableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilteredListenableCollection<T>
implements ListenableCollection<T> {
    protected final ListenableCollection<T> listenableCollection;
    protected Collection<CollectionListener<T>> listeners;

    public FilteredListenableCollection(ListenableCollection<T> listenableCollection) {
        this.listenableCollection = listenableCollection;
    }

    @Override
    public void addCollectionListener(CollectionListener<T> l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CollectionListener<T>>();
            this.listenableCollection.addCollectionListener(new CollectionListener<T>(){

                @Override
                public void collectionChanged(CollectionEvent<T> e) {
                    if (FilteredListenableCollection.this.listeners != null && !FilteredListenableCollection.this.listeners.isEmpty()) {
                        Collection filteredElements = e.getElements();
                        CollectionEvent filteredEvent = new CollectionEvent(FilteredListenableCollection.this, filteredElements, e.getType(), e.getFirstIndex(), e.getLastIndex());
                        for (CollectionListener listener : FilteredListenableCollection.this.listeners) {
                            listener.collectionChanged(filteredEvent);
                        }
                    }
                }
            });
        }
        this.listeners.add(l);
    }

    @Override
    public void removeCollectionListener(CollectionListener<T> l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    @Override
    public boolean add(T o) {
        return this.listenableCollection.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.listenableCollection.addAll(c);
    }

    @Override
    public void clear() {
        this.listenableCollection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.listenableCollection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.listenableCollection.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.listenableCollection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator(this.listenableCollection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        return this.listenableCollection.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.listenableCollection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.listenableCollection.retainAll(c);
    }

    @Override
    public int size() {
        return this.listenableCollection.size();
    }

    @Override
    public Object[] toArray() {
        return this.listenableCollection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.listenableCollection.toArray(a);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteredIterator<T>
    implements Iterator<T> {
        Iterator<T> iterator;

        public FilteredIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

