/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.jalico;

import com.nativelibs4java.jalico.DefaultListenableCollection;
import com.nativelibs4java.jalico.ListenableList;
import com.nativelibs4java.jalico.ListenableSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenableList<T>
extends DefaultListenableCollection<T>
implements ListenableList<T> {
    List<T> list;

    public DefaultListenableList(List<T> ilistst) {
        super(ilistst);
        this.list = ilistst;
    }

    public DefaultListenableList(List<T> list, ListenableSupport<T> collectionSupport) {
        super(list, collectionSupport);
        this.list = list;
    }

    @Override
    public boolean add(T o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.collectionSupport.fireAdded(this, Collections.singleton(element), index, index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int initSize = this.list.size();
        if (!this.list.addAll(index, c)) {
            if (this.list.size() != initSize) {
                throw new UnsupportedOperationException("Does not support listeners-enabled proxying of addAll(int, Collection) methods that are not atomical.");
            }
            return false;
        }
        this.collectionSupport.fireAdded(this, new ArrayList<T>(c), initSize, initSize + c.size() - 1);
        return true;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public T set(int index, T element) {
        T value = this.list.set(index, element);
        this.collectionSupport.fireUpdated(this, Collections.singleton(element), index, index);
        return value;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new DefaultListenableList<T>(this.list.subList(fromIndex, toIndex), this.collectionSupport);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        T removed = this.list.remove(index);
        if (removed != null) {
            this.collectionSupport.fireRemoved(this, Collections.singleton(removed), index, index);
        }
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        return i >= 0 && this.remove(i) != null;
    }

    @Override
    public void clear() {
        ArrayList copy = new ArrayList(this);
        this.collection.clear();
        this.collectionSupport.fireRemoved(this, copy, 0, copy.size() - 1);
    }
}

