/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.jalico;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCollection<U>
implements Collection<U> {
    Collection<Collection<? extends U>> collections;

    public CompoundCollection() {
        this.collections = new LinkedList<Collection<? extends U>>();
    }

    public CompoundCollection(Collection<Collection<? extends U>> lists) {
        this.collections = new ArrayList<Collection<U>>(lists);
    }

    public CompoundCollection(Collection<? extends U> ... lists) {
        this((Collection<Collection<? extends U>>)Arrays.asList(lists));
    }

    public void addComponent(Collection<U> col) {
        this.collections.add(col);
    }

    public boolean removeComponent(Collection<U> col) {
        return this.collections.remove(col);
    }

    @Override
    public int size() {
        int s = 0;
        for (Collection<U> col : this.collections) {
            s += col.size();
        }
        return s;
    }

    public void clearComponents() {
        this.collections.clear();
    }

    @Override
    public void clear() {
        for (Collection<U> col : this.collections) {
            col.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        for (Collection<U> col : this.collections) {
            if (col.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        int len = this.size();
        Object[] a = new Object[len];
        int i = 0;
        for (U element : this) {
            a[i] = element;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        int size = this.size();
        Class<?> clazz = objects.getClass().getComponentType();
        Object[] array = (Object[])Array.newInstance(clazz, size);
        int i = 0;
        for (U element : this) {
            array[i] = clazz.cast(element);
        }
        return array;
    }

    @Override
    @Deprecated
    public boolean add(U object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        for (Collection<U> col : this.collections) {
            if (!col.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        boolean changed = false;
        for (Collection<U> col : this.collections) {
            if (!col.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends U> col) {
        boolean changed = false;
        for (U u : col) {
            changed = this.add(u) || changed;
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        for (Object o : col) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        boolean changed = false;
        for (Object o : col) {
            changed = this.remove(o) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        boolean changed = false;
        Iterator<U> it = this.iterator();
        while (it.hasNext()) {
            if (col.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Iterator<U> iterator() {
        return new Iterator<U>(){
            Iterator<? extends Collection<? extends U>> collectionsIterator;
            Iterator<? extends U> currentCollectionIterator;
            {
                this.collectionsIterator = CompoundCollection.this.collections.iterator();
                this.currentCollectionIterator = this.collectionsIterator.hasNext() ? this.collectionsIterator.next().iterator() : new Vector(0).iterator();
            }

            @Override
            public boolean hasNext() {
                boolean collectionExhausted = false;
                do {
                    collectionExhausted = true;
                    if (this.currentCollectionIterator.hasNext()) {
                        return true;
                    }
                    if (!this.collectionsIterator.hasNext()) continue;
                    this.currentCollectionIterator = this.collectionsIterator.next().iterator();
                    collectionExhausted = false;
                } while (!collectionExhausted);
                return false;
            }

            @Override
            public U next() {
                boolean collectionExhausted = false;
                do {
                    collectionExhausted = true;
                    if (this.currentCollectionIterator.hasNext()) {
                        return this.currentCollectionIterator.next();
                    }
                    this.currentCollectionIterator = this.collectionsIterator.next().iterator();
                } while (!(collectionExhausted = false));
                return null;
            }

            @Override
            public void remove() {
                this.currentCollectionIterator.remove();
            }
        };
    }
}

