/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.jalico;

import com.nativelibs4java.jalico.Adapter;
import com.nativelibs4java.jalico.CollectionEvent;
import com.nativelibs4java.jalico.CollectionListener;
import com.nativelibs4java.jalico.ListenableCollection;
import com.nativelibs4java.jalico.ListenableSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptedCollection<U, V>
extends AbstractCollection<V>
implements ListenableCollection<V> {
    protected final Collection<U> collection;
    protected final Adapter<U, V> forwardAdapter;
    protected final Adapter<V, U> backwardAdapter;
    protected ListenableSupport<V> collectionSupport;
    protected boolean currentlyCausingChange = false;

    public AdaptedCollection(Collection<U> collection, Adapter<U, V> forwardAdapter) {
        this(collection, forwardAdapter, null);
    }

    public AdaptedCollection(Collection<U> collection, Adapter<U, V> forwardAdapter, Adapter<V, U> backwardAdapter) {
        if (forwardAdapter == null) {
            throw new NullPointerException("AdaptedCollection needs a non-null forward adapter");
        }
        this.collection = collection;
        this.forwardAdapter = forwardAdapter;
        this.backwardAdapter = backwardAdapter;
    }

    public Adapter<U, V> getForwardAdapter() {
        return this.forwardAdapter;
    }

    public Adapter<V, U> getBackwardAdapter() {
        return this.backwardAdapter;
    }

    @Override
    public Iterator<V> iterator() {
        return new IteratorAdapter(this.collection.iterator());
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
            try {
                this.currentlyCausingChange = true;
                ArrayList removedElements = new ArrayList(this);
                this.collection.clear();
                this.collectionSupport.fireRemoved(this, removedElements, 0, removedElements.size() - 1);
                Object var3_2 = null;
                this.currentlyCausingChange = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.currentlyCausingChange = false;
                throw throwable;
            }
        } else {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V value) {
        block5: {
            if (this.backwardAdapter == null) {
                throw new UnsupportedOperationException("No backward adapter in this AdapterCollection");
            }
            try {
                this.currentlyCausingChange = true;
                if (!this.collection.add(this.backwardAdapter.adapt(value))) break block5;
                if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                    this.collectionSupport.fireAdded(this, Collections.singleton(value));
                }
                boolean bl = true;
                Object var4_4 = null;
                this.currentlyCausingChange = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.currentlyCausingChange = false;
                throw throwable;
            }
        }
        boolean bl = false;
        Object var4_5 = null;
        this.currentlyCausingChange = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        if (this.backwardAdapter == null) {
            int i = 0;
            Iterator<U> it = this.collection.iterator();
            while (it.hasNext()) {
                if (this.forwardAdapter.adapt(it.next()).equals(value)) {
                    try {
                        this.currentlyCausingChange = true;
                        it.remove();
                        if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                            this.collectionSupport.fireRemoved(this, Collections.singleton(value), i, i);
                        }
                        boolean bl = true;
                        Object var6_5 = null;
                        this.currentlyCausingChange = false;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.currentlyCausingChange = false;
                        throw throwable;
                    }
                }
                ++i;
            }
            return false;
        }
        return this.removeWithoutBackWardAdapter(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeWithoutBackWardAdapter(Object value) {
        block4: {
            try {
                this.currentlyCausingChange = true;
                if (!this.collection.remove(this.backwardAdapter.adapt(value))) break block4;
                if (this.collectionSupport != null && this.collectionSupport.hasListeners()) {
                    this.collectionSupport.fireRemoved(this, Collections.singleton(value));
                }
                boolean bl = true;
                Object var4_4 = null;
                this.currentlyCausingChange = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.currentlyCausingChange = false;
                throw throwable;
            }
        }
        boolean bl = false;
        Object var4_5 = null;
        this.currentlyCausingChange = false;
        return bl;
    }

    @Override
    public boolean contains(Object value) {
        if (this.backwardAdapter != null) {
            return this.collection.contains(this.backwardAdapter.adapt(value));
        }
        for (U element : this.collection) {
            if (!this.forwardAdapter.adapt(element).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addCollectionListener(CollectionListener<V> l) {
        if (this.collectionSupport == null) {
            this.collectionSupport = new ListenableSupport();
            if (this.collection instanceof ListenableCollection) {
                ((ListenableCollection)this.collection).addCollectionListener(new CollectionListener<U>(){

                    @Override
                    public void collectionChanged(CollectionEvent<U> e) {
                        if (AdaptedCollection.this.currentlyCausingChange) {
                            return;
                        }
                        if (AdaptedCollection.this.collectionSupport == null || !AdaptedCollection.this.collectionSupport.hasListeners()) {
                            return;
                        }
                        AdaptedCollection.this.collectionSupport.fireEvent(AdaptedCollection.this, new AdaptedCollection(e.getElements(), AdaptedCollection.this.forwardAdapter, AdaptedCollection.this.backwardAdapter), e.getType(), e.getFirstIndex(), e.getLastIndex());
                    }
                });
            }
        }
        this.collectionSupport.addCollectionListener(l);
    }

    @Override
    public void removeCollectionListener(CollectionListener<V> l) {
        if (this.collectionSupport == null) {
            return;
        }
        this.collectionSupport.removeCollectionListener(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IteratorAdapter
    implements Iterator<V> {
        protected Iterator<U> iterator;
        protected V lastValue;

        public IteratorAdapter(Iterator<U> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.lastValue = AdaptedCollection.this.forwardAdapter.adapt(this.iterator.next());
            return this.lastValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                AdaptedCollection.this.currentlyCausingChange = true;
                this.iterator.remove();
                if (AdaptedCollection.this.collectionSupport != null && AdaptedCollection.this.collectionSupport.hasListeners()) {
                    AdaptedCollection.this.collectionSupport.fireRemoved(AdaptedCollection.this, Collections.singleton(this.lastValue));
                }
                Object var2_1 = null;
                AdaptedCollection.this.currentlyCausingChange = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                AdaptedCollection.this.currentlyCausingChange = false;
                throw throwable;
            }
            this.lastValue = null;
        }
    }
}

