/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.CombinedAnalysis;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.LiveLocals;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Cons;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class CombinedDUAnalysis
extends BackwardFlowAnalysis
implements CombinedAnalysis,
LocalDefs,
LocalUses,
LiveLocals {
    private final Map<Cons, List> defsOfAt = new HashMap<Cons, List>();
    private final Map<Unit, List> usesOf = new HashMap<Unit, List>();
    private final Map<Unit, List> liveLocalsBefore = new HashMap<Unit, List>();
    private final Map<Unit, List> liveLocalsAfter = new HashMap<Unit, List>();
    private final Map<ValueBox, Unit> useBoxToUnit = new HashMap<ValueBox, Unit>();
    private final Map<Unit, Value> unitToLocalDefed = new HashMap<Unit, Value>();
    private final Map<Unit, ArraySparseSet> unitToLocalUseBoxes = new HashMap<Unit, ArraySparseSet>();
    private final MultiMap localToUseBoxes = new HashMultiMap();

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        Cons cons = new Cons(l, s);
        ArrayList ret = this.defsOfAt.get(cons);
        if (ret == null) {
            ret = new ArrayList();
            this.defsOfAt.put(cons, ret);
        }
        return ret;
    }

    @Override
    public List getUsesOf(Unit u) {
        ArrayList<UnitValueBoxPair> ret = this.usesOf.get(u);
        if (ret == null) {
            Local def = this.localDefed(u);
            if (def == null) {
                ret = Collections.EMPTY_LIST;
                this.usesOf.put(u, ret);
            } else {
                ret = new ArrayList<UnitValueBoxPair>();
                this.usesOf.put(u, ret);
                Iterator vbIt = ((FlowSet)this.getFlowAfter(u)).iterator();
                while (vbIt.hasNext()) {
                    ValueBox vb = (ValueBox)vbIt.next();
                    if (vb.getValue() != def) continue;
                    ret.add(new UnitValueBoxPair(this.useBoxToUnit.get(vb), vb));
                }
            }
        }
        return ret;
    }

    @Override
    public List getLiveLocalsBefore(Unit u) {
        ArrayList ret = this.liveLocalsBefore.get(u);
        if (ret == null) {
            HashSet<Value> hs = new HashSet<Value>();
            Iterator vbIt = ((FlowSet)this.getFlowBefore(u)).iterator();
            while (vbIt.hasNext()) {
                ValueBox vb = (ValueBox)vbIt.next();
                hs.add(vb.getValue());
            }
            ret = new ArrayList(hs);
            this.liveLocalsBefore.put(u, ret);
        }
        return ret;
    }

    @Override
    public List getLiveLocalsAfter(Unit u) {
        ArrayList ret = this.liveLocalsAfter.get(u);
        if (ret == null) {
            HashSet<Value> hs = new HashSet<Value>();
            Iterator vbIt = ((FlowSet)this.getFlowAfter(u)).iterator();
            while (vbIt.hasNext()) {
                ValueBox vb = (ValueBox)vbIt.next();
                hs.add(vb.getValue());
            }
            ret = new ArrayList(hs);
            this.liveLocalsAfter.put(u, ret);
        }
        return ret;
    }

    private Local localDefed(Unit u) {
        return (Local)this.unitToLocalDefed.get(u);
    }

    public static CombinedAnalysis v(UnitGraph graph) {
        return new CombinedDUAnalysis(graph);
    }

    private CombinedDUAnalysis(UnitGraph graph) {
        super(graph);
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Constructing CombinedDUAnalysis...");
        }
        for (Unit u : graph) {
            List<Value> defs = this.localsInBoxes(u.getDefBoxes());
            if (defs.size() == 1) {
                this.unitToLocalDefed.put(u, defs.get(0));
            } else if (defs.size() != 0) {
                throw new RuntimeException("Locals defed in " + u + ": " + defs.size());
            }
            ArraySparseSet localUseBoxes = new ArraySparseSet();
            for (ValueBox vb : u.getUseBoxes()) {
                Value v = vb.getValue();
                if (!(v instanceof Local)) continue;
                localUseBoxes.add(vb);
                if (this.useBoxToUnit.containsKey(vb)) {
                    throw new RuntimeException("Aliased ValueBox " + vb + " in Unit " + u);
                }
                this.useBoxToUnit.put(vb, u);
                this.localToUseBoxes.put(v, vb);
            }
            this.unitToLocalUseBoxes.put(u, localUseBoxes);
        }
        this.doAnalysis();
        for (Unit defUnit : graph) {
            Local localDefed = this.localDefed(defUnit);
            if (localDefed == null) continue;
            Iterator vbIt = ((FlowSet)this.getFlowAfter(defUnit)).iterator();
            while (vbIt.hasNext()) {
                ValueBox vb = (ValueBox)vbIt.next();
                if (vb.getValue() != localDefed) continue;
                Unit useUnit = this.useBoxToUnit.get(vb);
                this.getDefsOfAt(localDefed, useUnit).add(defUnit);
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + graph.getBody().getMethod().getName() + "]     Finished CombinedDUAnalysis...");
        }
    }

    private List<Value> localsInBoxes(List boxes) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (ValueBox vb : boxes) {
            Value v = vb.getValue();
            if (!(v instanceof Local)) continue;
            ret.add(v);
        }
        return ret;
    }

    protected void merge(Object inoutO, Object inO) {
        FlowSet inout = (FlowSet)inoutO;
        FlowSet in = (FlowSet)inO;
        inout.union(in);
    }

    @Override
    protected void merge(Object in1O, Object in2O, Object outO) {
        FlowSet in1 = (FlowSet)in1O;
        FlowSet in2 = (FlowSet)in2O;
        FlowSet out = (FlowSet)outO;
        in1.union(in2, out);
    }

    @Override
    protected void flowThrough(Object outValue, Object unit, Object inValue) {
        Unit u = (Unit)unit;
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Local def = this.localDefed(u);
        out.copy(in);
        if (def != null) {
            Set boxesDefed = this.localToUseBoxes.get(def);
            for (ValueBox vb : in.toList()) {
                if (!boxesDefed.contains(vb)) continue;
                in.remove(vb);
            }
        }
        in.union(this.unitToLocalUseBoxes.get(u));
    }

    @Override
    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected Object newInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

