/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.FlowAnalysis;

public abstract class BackwardFlowAnalysis<N, A>
extends FlowAnalysis<N, A> {
    public BackwardFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return false;
    }

    @Override
    protected void doAnalysis() {
        HashMap numbers = new HashMap();
        List orderedUnits = this.constructOrderer().newList(this.graph, true);
        int i = 1;
        for (Object u : orderedUnits) {
            numbers.put(u, new Integer(i));
            ++i;
        }
        Collection changedUnits = this.constructWorklist(numbers);
        for (Object s : this.graph) {
            changedUnits.add(s);
            this.unitToBeforeFlow.put(s, this.newInitialFlow());
            this.unitToAfterFlow.put(s, this.newInitialFlow());
        }
        List tails = this.graph.getTails();
        for (Object s : tails) {
            this.unitToAfterFlow.put(s, this.entryInitialFlow());
        }
        Object previousBeforeFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            FlowInfo fi;
            Object s = changedUnits.iterator().next();
            changedUnits.remove(s);
            boolean isTail = tails.contains(s);
            this.copy(this.unitToBeforeFlow.get(s), previousBeforeFlow);
            List succs = this.graph.getSuccsOf(s);
            Object afterFlow = this.unitToAfterFlow.get(s);
            if (succs.size() == 1) {
                this.copy(this.unitToBeforeFlow.get(succs.get(0)), afterFlow);
            } else if (succs.size() != 0) {
                Iterator succIt = succs.iterator();
                this.copy(this.unitToBeforeFlow.get(succIt.next()), afterFlow);
                while (succIt.hasNext()) {
                    Object otherBranchFlow = this.unitToBeforeFlow.get(succIt.next());
                    this.mergeInto(s, afterFlow, otherBranchFlow);
                }
                if (isTail && succs.size() != 0) {
                    this.mergeInto(s, afterFlow, this.entryInitialFlow());
                }
            }
            Object beforeFlow = this.unitToBeforeFlow.get(s);
            if (Options.v().interactive_mode()) {
                Object savedFlow = this.newInitialFlow();
                if (this.filterUnitToAfterFlow != null) {
                    savedFlow = this.filterUnitToAfterFlow.get(s);
                    this.copy(this.filterUnitToAfterFlow.get(s), savedFlow);
                } else {
                    this.copy(afterFlow, savedFlow);
                }
                fi = new FlowInfo(savedFlow, s, false);
                if (InteractionHandler.v().getStopUnitList() != null && InteractionHandler.v().getStopUnitList().contains(s)) {
                    InteractionHandler.v().handleStopAtNodeEvent(s);
                }
                InteractionHandler.v().handleAfterAnalysisEvent(fi);
            }
            this.flowThrough(afterFlow, s, beforeFlow);
            if (Options.v().interactive_mode()) {
                Object bSavedFlow = this.newInitialFlow();
                if (this.filterUnitToBeforeFlow != null) {
                    bSavedFlow = this.filterUnitToBeforeFlow.get(s);
                    this.copy(this.filterUnitToBeforeFlow.get(s), bSavedFlow);
                } else {
                    this.copy(beforeFlow, bSavedFlow);
                }
                fi = new FlowInfo(bSavedFlow, s, true);
                InteractionHandler.v().handleBeforeAnalysisEvent(fi);
            }
            if (beforeFlow.equals(previousBeforeFlow)) continue;
            for (Object pred : this.graph.getPredsOf(s)) {
                changedUnits.add(pred);
            }
        }
    }

    protected Collection<N> constructWorklist(final Map<N, Integer> numbers) {
        return new TreeSet(new Comparator<N>(){

            @Override
            public int compare(N o1, N o2) {
                Integer i1 = (Integer)numbers.get(o1);
                Integer i2 = (Integer)numbers.get(o2);
                return i1 - i2;
            }
        });
    }
}

