/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import soot.FastHierarchy;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.grimp.NewInvokeExpr;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleValueSwitch;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StmtSwitch;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.toolkits.exceptions.AbstractThrowAnalysis;
import soot.toolkits.exceptions.ThrowableSet;

public class UnitThrowAnalysis
extends AbstractThrowAnalysis {
    private final ThrowableSet implicitThrowExceptions;
    private static final IntConstant INT_CONSTANT_ZERO = IntConstant.v(0);
    private static final LongConstant LONG_CONSTANT_ZERO = LongConstant.v(0L);

    public UnitThrowAnalysis(Singletons.Global g) {
        this.implicitThrowExceptions = ThrowableSet.Manager.v().VM_ERRORS.add(ThrowableSet.Manager.v().NULL_POINTER_EXCEPTION).add(ThrowableSet.Manager.v().ILLEGAL_MONITOR_STATE_EXCEPTION);
    }

    protected UnitThrowAnalysis() {
        this.implicitThrowExceptions = ThrowableSet.Manager.v().VM_ERRORS.add(ThrowableSet.Manager.v().NULL_POINTER_EXCEPTION).add(ThrowableSet.Manager.v().ILLEGAL_MONITOR_STATE_EXCEPTION);
    }

    public static UnitThrowAnalysis v() {
        return G.v().soot_toolkits_exceptions_UnitThrowAnalysis();
    }

    @Override
    public ThrowableSet mightThrow(Unit u) {
        UnitSwitch sw = new UnitSwitch();
        u.apply(sw);
        return sw.getResult();
    }

    @Override
    public ThrowableSet mightThrowImplicitly(ThrowStmt t) {
        return this.implicitThrowExceptions;
    }

    ThrowableSet mightThrow(Value v) {
        ValueSwitch sw = new ValueSwitch();
        v.apply(sw);
        return sw.getResult();
    }

    ThrowableSet mightThrow(SootMethod m) {
        return ThrowableSet.Manager.v().ALL_THROWABLES;
    }

    protected class UnitSwitch
    implements StmtSwitch {
        private final ThrowableSet.Manager mgr = ThrowableSet.Manager.v();
        private ThrowableSet result;

        protected UnitSwitch() {
            this.result = this.mgr.VM_ERRORS;
        }

        ThrowableSet getResult() {
            return this.result;
        }

        @Override
        public void caseAssignStmt(AssignStmt s) {
            Value lhs = s.getLeftOp();
            if (lhs instanceof ArrayRef && (lhs.getType() instanceof UnknownType || lhs.getType() instanceof RefType)) {
                this.result = this.result.add(this.mgr.ARRAY_STORE_EXCEPTION);
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getLeftOp()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getRightOp()));
        }

        @Override
        public void caseBreakpointStmt(BreakpointStmt s) {
        }

        @Override
        public void caseEnterMonitorStmt(EnterMonitorStmt s) {
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getOp()));
        }

        @Override
        public void caseExitMonitorStmt(ExitMonitorStmt s) {
            this.result = this.result.add(this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getOp()));
        }

        @Override
        public void caseGotoStmt(GotoStmt s) {
        }

        @Override
        public void caseIdentityStmt(IdentityStmt s) {
        }

        @Override
        public void caseIfStmt(IfStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getCondition()));
        }

        @Override
        public void caseInvokeStmt(InvokeStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getInvokeExpr()));
        }

        @Override
        public void caseLookupSwitchStmt(LookupSwitchStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getKey()));
        }

        @Override
        public void caseNopStmt(NopStmt s) {
        }

        @Override
        public void caseRetStmt(RetStmt s) {
        }

        @Override
        public void caseReturnStmt(ReturnStmt s) {
            this.result = this.result.add(this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getOp()));
        }

        @Override
        public void caseReturnVoidStmt(ReturnVoidStmt s) {
            this.result = this.result.add(this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
        }

        @Override
        public void caseTableSwitchStmt(TableSwitchStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getKey()));
        }

        @Override
        public void caseThrowStmt(ThrowStmt s) {
            this.result = UnitThrowAnalysis.this.mightThrowImplicitly(s);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrowExplicitly(s));
        }

        @Override
        public void defaultCase(Object obj) {
        }
    }

    protected class ValueSwitch
    implements JimpleValueSwitch {
        private final ThrowableSet.Manager mgr = ThrowableSet.Manager.v();
        private ThrowableSet result;

        protected ValueSwitch() {
            this.result = this.mgr.VM_ERRORS;
        }

        ThrowableSet getResult() {
            return this.result;
        }

        @Override
        public void caseDoubleConstant(DoubleConstant c) {
        }

        @Override
        public void caseFloatConstant(FloatConstant c) {
        }

        @Override
        public void caseIntConstant(IntConstant c) {
        }

        @Override
        public void caseLongConstant(LongConstant c) {
        }

        @Override
        public void caseNullConstant(NullConstant c) {
        }

        @Override
        public void caseStringConstant(StringConstant c) {
        }

        @Override
        public void caseClassConstant(ClassConstant c) {
        }

        @Override
        public void caseAddExpr(AddExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseAndExpr(AndExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmpExpr(CmpExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmpgExpr(CmpgExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmplExpr(CmplExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseDivExpr(DivExpr expr) {
            this.caseBinopDivExpr(expr);
        }

        @Override
        public void caseEqExpr(EqExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseNeExpr(NeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseGeExpr(GeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseGtExpr(GtExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseLeExpr(LeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseLtExpr(LtExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseMulExpr(MulExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseOrExpr(OrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseRemExpr(RemExpr expr) {
            this.caseBinopDivExpr(expr);
        }

        @Override
        public void caseShlExpr(ShlExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseShrExpr(ShrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseUshrExpr(UshrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseSubExpr(SubExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseXorExpr(XorExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseSpecialInvokeExpr(SpecialInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseStaticInvokeExpr(StaticInvokeExpr expr) {
            this.result = this.result.add(this.mgr.INITIALIZATION_ERRORS);
            for (int i = 0; i < expr.getArgCount(); ++i) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getArg(i)));
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getMethod()));
        }

        @Override
        public void caseVirtualInvokeExpr(VirtualInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseDynamicInvokeExpr(DynamicInvokeExpr expr) {
        }

        @Override
        public void caseCastExpr(CastExpr expr) {
            this.result = this.result.add(this.mgr.RESOLVE_CLASS_ERRORS);
            Type fromType = expr.getOp().getType();
            Type toType = expr.getCastType();
            if (toType instanceof RefLikeType) {
                FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
                if (fromType == null || fromType instanceof UnknownType || !(fromType instanceof NullType) && !h.canStoreType(fromType, toType)) {
                    this.result = this.result.add(this.mgr.CLASS_CAST_EXCEPTION);
                }
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseInstanceOfExpr(InstanceOfExpr expr) {
            this.result = this.result.add(this.mgr.RESOLVE_CLASS_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseNewArrayExpr(NewArrayExpr expr) {
            Value count;
            if (expr.getBaseType() instanceof RefLikeType) {
                this.result = this.result.add(this.mgr.RESOLVE_CLASS_ERRORS);
            }
            if (!((count = expr.getSize()) instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                this.result = this.result.add(this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(count));
        }

        @Override
        public void caseNewMultiArrayExpr(NewMultiArrayExpr expr) {
            this.result = this.result.add(this.mgr.RESOLVE_CLASS_ERRORS);
            for (int i = 0; i < expr.getSizeCount(); ++i) {
                Value count = expr.getSize(i);
                if (!(count instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                    this.result = this.result.add(this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
                }
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(count));
            }
        }

        @Override
        public void caseNewExpr(NewExpr expr) {
            this.result = this.result.add(this.mgr.INITIALIZATION_ERRORS);
            for (ValueBox box : expr.getUseBoxes()) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(box.getValue()));
            }
        }

        @Override
        public void caseLengthExpr(LengthExpr expr) {
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseNegExpr(NegExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseArrayRef(ArrayRef ref) {
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(this.mgr.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getBase()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getIndex()));
        }

        @Override
        public void caseStaticFieldRef(StaticFieldRef ref) {
            this.result = this.result.add(this.mgr.INITIALIZATION_ERRORS);
        }

        @Override
        public void caseInstanceFieldRef(InstanceFieldRef ref) {
            this.result = this.result.add(this.mgr.RESOLVE_FIELD_ERRORS);
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getBase()));
        }

        @Override
        public void caseParameterRef(ParameterRef v) {
        }

        @Override
        public void caseCaughtExceptionRef(CaughtExceptionRef v) {
        }

        @Override
        public void caseThisRef(ThisRef v) {
        }

        @Override
        public void caseLocal(Local l) {
        }

        public void caseNewInvokeExpr(NewInvokeExpr e) {
            this.caseStaticInvokeExpr(e);
        }

        @Override
        public void defaultCase(Object obj) {
        }

        private void caseBinopExpr(BinopExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp1()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp2()));
        }

        private void caseBinopDivExpr(BinopExpr expr) {
            Value divisor = expr.getOp2();
            Type divisorType = divisor.getType();
            if (divisorType instanceof UnknownType) {
                this.result = this.result.add(this.mgr.ARITHMETIC_EXCEPTION);
            } else if (divisorType instanceof IntegerType && (!(divisor instanceof IntConstant) || ((IntConstant)divisor).equals(INT_CONSTANT_ZERO))) {
                this.result = this.result.add(this.mgr.ARITHMETIC_EXCEPTION);
            } else if (divisorType == LongType.v() && (!(divisor instanceof LongConstant) || ((LongConstant)divisor).equals(LONG_CONSTANT_ZERO))) {
                this.result = this.result.add(this.mgr.ARITHMETIC_EXCEPTION);
            }
            this.caseBinopExpr(expr);
        }

        private void caseInstanceInvokeExpr(InstanceInvokeExpr expr) {
            this.result = this.result.add(this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(this.mgr.NULL_POINTER_EXCEPTION);
            for (int i = 0; i < expr.getArgCount(); ++i) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getArg(i)));
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getBase()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getMethod()));
        }
    }
}

